package com.interpress_project.modernshare.client.controller.model;

import java.util.ArrayList;
import java.util.Date;

import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

public class SVNFolder implements ISVNFileItem {
	private String name;
	private String author;
	private long revision;
	private long lastChangedRevision;
	private Date lastChangedDate;
	private String url;
	private String uuid;

	/**
	 * LocalSVNFolder
	 * @param name
	 * @param fileSize
	 * @param author
	 * @param lastChangedDate
	 * @param revision
	 * @param lastChangedRevision
	 * @param url
	 * @param uuid
	 */
	public SVNFolder(String name, long fileSize, String author, Date lastChangedDate, long revision,
	    long lastChangedRevision, String url, String uuid) {
		this.name = name;
		this.author = author;
		this.lastChangedDate = lastChangedDate;
		this.revision = revision;
		this.lastChangedRevision = lastChangedRevision;
		this.url = url;
		this.uuid = uuid;
	}

	/**
	 * getFilesize
	 */
	public long getFilesize() {
		return -1;
	}

	/**
	 * getLastChangedDate
	 */
	public Date getLastChangedDate() {
		return lastChangedDate;
	}

	/**
	 * getLastChangedRevision
	 */
	public long getLastChangedRevision() {
		return lastChangedRevision;
	}

	/**
	 * getLastCommitAuthor
	 */
	public String getLastCommitAuthor() {
		return author;
	}

	/**
	 * getName
	 */
	public String getName() {
		return name;
	}

	/**
	 * isDirectory
	 */
	public boolean isDirectory() {
		return true;
	}

	/**
	 * getSVNItems
	 * @throws InternalFailException 
	 */
	public ISVNFileItem[] getSVNItems() throws InternalFailException {
		ArrayList<ISVNFileItem> list = null;
		RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();

		list = svnmgr.getSVNFileItems(url);
		return list.toArray(new ISVNFileItem[list.size()]);
	}

	/**
	 * getRevisionInfo
	 * @throws InternalFailException 
	 */
	public ISVNFileItem[] getRevisionInfo() throws InternalFailException {
		ArrayList<ISVNFileItem> list = null;
		RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();

		list = svnmgr.getRevisionInfo(url);

		return list.toArray(new ISVNFileItem[list.size()]);
	}

	/**
	 * getRevision
	 */
	public long getRevision() {
		return revision;
	}

	/**
	 * getURL
	 */
	public String getURL() {
		return url;
	}

	/**
	 * getUUID
	 */
	public String getUUID() {
		return uuid;
	}
}
