package com.interpress_project.modernshare.client.view;

import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;

import com.interpress_project.modernshare.client.controller.actions.AboutAction;
import com.interpress_project.modernshare.client.controller.actions.ChangePasswordAction;
import com.interpress_project.modernshare.client.controller.actions.CheckOutAction;
import com.interpress_project.modernshare.client.controller.actions.ExitAction;
import com.interpress_project.modernshare.client.controller.actions.HelpAction;
import com.interpress_project.modernshare.client.controller.actions.PropertyAction;
import com.interpress_project.modernshare.client.controller.actions.RegisterTargetAction;
import com.interpress_project.modernshare.client.controller.actions.StartupSyncAction;

public final class MfCoolBar extends CoolBarManager {
	/**
	 * MfCoolBar
	 * @param fmgr
	 * @param style
	 */
	public MfCoolBar(ViewManager fmgr, int style) {
		super(style);

		initComponents(fmgr, style);
	}

	/**
	 * initComponents
	 * 
	 * @param fmgr
	 * @param style
	 */
	private void initComponents(ViewManager fmgr, int style) {
		/**
		 * File
		 */
		ToolBarManager fileToolBar = new ToolBarManager(style);
		fileToolBar.add(new PropertyAction(fmgr));
		fileToolBar.add(new Separator());
		fileToolBar.add(new ExitAction(fmgr));
		ToolBarContributionItem fileToolBarItem = new ToolBarContributionItem(fileToolBar);
		add(fileToolBarItem);

		/**
		 * Tool
		 */
		ToolBarManager toolToolBar = new ToolBarManager(style);
		toolToolBar.add(new RegisterTargetAction(fmgr));
		toolToolBar.add(new CheckOutAction(fmgr));
		toolToolBar.add(new StartupSyncAction(fmgr));		
		toolToolBar.add(new Separator());
		toolToolBar.add(new ChangePasswordAction(fmgr));
		ToolBarContributionItem toolToolBarItem = new ToolBarContributionItem(toolToolBar);
		add(toolToolBarItem);

		/**
		 * Help
		 */
		ToolBarManager helpToolBar = new ToolBarManager(style);
		helpToolBar.add(new HelpAction(fmgr));
		helpToolBar.add(new Separator());
		helpToolBar.add(new AboutAction(fmgr));
		ToolBarContributionItem helpToolBarItem = new ToolBarContributionItem(helpToolBar);
		add(helpToolBarItem);
	}
}