package com.interpress_project.modernshare.client.view.localfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class FileTableLabelProvider implements ITableLabelProvider {
	private final SystemBase sb = SystemBase.getInstance();

	/**
	 * getColumnText
	 *	0	  Name
	 *	1  Size 
	 *	2  Author 
	 *  3  Revision 
	 *  4  LastChangedRevision 
	 *  5  LastChangedDate 
	 *  6  Host 
	 *  7  Path 
	 *  8  uuid
	 *  
	 * @param element Object
	 * @param column_index int
	 * @return String
	 */
	public String getColumnText(Object element, int column_index) {
		switch (column_index) {
			default:
				sb.getLogger().fatal("LocalTable`掞ɕsȃCfbNXԍn܂B" + column_index);
				return "";

			case 0: // Name
				return ((ISVNFileItem) element).getName();

			case 1: {// File size
				long size = ((ISVNFileItem) element).getFilesize();
				if (size >= 0) {
					DecimalFormat decformat = new DecimalFormat("###,###,###,###");
					return decformat.format(size);
				}
				return "";
			}

			case 2: // Author
				return ((ISVNFileItem) element).getLastCommitAuthor();

			case 3: { // Revision
				String s = String.valueOf(((ISVNFileItem) element).getRevision());
				return s;
			}

			case 4: { // LastChangedRevision
				String s = String.valueOf(((ISVNFileItem) element).getLastChangedRevision());
				return s;
			}
			case 5: {// LastChangedDate
				return ((ISVNFileItem) element).getLastChangedDate().toString();
			}
			case 6: {// Host
				String url = ((ISVNFileItem) element).getURL();
				URI u = null;
				try {
					u = new URI(url);
				}
				catch (URISyntaxException ex) {
					sb.getLogger().fatal("LocalTable`掞URIϊɎs܂B(6)" + url);
					return "";
				}
				return u.getHost();
			}
			case 7: {// Path
				String url = ((ISVNFileItem) element).getURL();
				URI u = null;
				try {
					u = new URI(url);
				}
				catch (URISyntaxException ex) {
					sb.getLogger().fatal("LocalTable`掞URIϊɎs܂B(7)" + url);
					return "";
				}
				return u.getPath();
			}
			case 8: { // UUID
				return ((ISVNFileItem) element).getUUID();
			}
		}
	}

	/**
	 * addListener
	 *
	 * @param ilabelproviderlistener ILabelProviderListener
	 */
	public void addListener(ILabelProviderListener ilabelproviderlistener) {
	}

	/**
	 * dispose
	 */
	public void dispose() {
	}

	/**
	 * isLabelProperty
	 *
	 * @param obj Object
	 * @param s String
	 * @return boolean
	 */
	public boolean isLabelProperty(Object obj, String s) {
		return false;
	}

	/**
	 * removeListener
	 *
	 * @param ilabelproviderlistener ILabelProviderListener
	 */
	public void removeListener(ILabelProviderListener ilabelproviderlistener) {
	}

	/**
	 * getColumnImage
	 *
	 * @param element Object
	 * @param column_index int
	 * @return Image
	 */
	public Image getColumnImage(Object element, int column_index) {
		if (column_index != 0) {
			return null;
		}
		if (((ISVNFileItem) element).isDirectory()) {
			return ImageFactory.getInstance().getImage("folder");
		}
		else {
			String fileName = ((ISVNFileItem) element).getURL();
			return ImageFactory.getInstance().getAssociatedImageToFile(fileName);
		}
	}
}
