package com.interpress_project.modernshare.client.view.localfs;

import java.io.File;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalFile;
import com.interpress_project.modernshare.client.controller.model.LocalFolder;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RootStatus;

public class FileTreeLabelProvider extends LabelProvider {
	/**
	 * getText
	 * @param element Object
	 * @return String
	 */
	public String getText(Object element) {
		String name = ((IFileItem) element).getName();
		if (element instanceof LocalRoot) {
			String path = ((IFileItem) element).getAbsolutePath();
			return name + " (" + path + ")";
		}
		return name;
	}

	/**
	 * getImage
	 * @param element Object
	 * @return Image
	 */
	public Image getImage(Object element) {
		Image image = null;

		if (element instanceof LocalRoot) {
			RootStatus status = ((LocalRoot) element).getStatus();
			boolean bPc2host = ((LocalRoot) element).getPc2host();

			if (new File(((LocalRoot) element).getAbsolutePath()).exists() == false) {
				status = RootStatus.disable;
			}
			switch (status) {
				default: {
					break;
				}
				case active: {
					if (bPc2host) {
						image = ImageFactory.getInstance().getImage("connected");
					}
					else {
						image = ImageFactory.getInstance().getImage("connected_ro");
					}
					break;
				}
				case deactive: {
					image = ImageFactory.getInstance().getImage("unconnected");
					break;
				}
				case disable: {
					image = ImageFactory.getInstance().getImage("disable");
					break;
				}
			}
		}
		else if (element instanceof LocalFolder) {
			image = ImageFactory.getInstance().getImage("folder");
		}
		else if (element instanceof LocalFile) {
			String fileName = ((LocalFile) element).getAbsolutePath();
			image = ImageFactory.getInstance().getAssociatedImageToFile(fileName);
		}
		return image;
	}
}
