package com.interpress_project.modernshare.client.view.remotefs;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.SVNFolder;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class RemoteAllowOnlyFoldersFilter extends ViewerFilter {
	/**
	 * select
	 * @param viewer Viewer
	 * @param parent Object
	 * @param element Object
	 * @return boolean
	 */
	public boolean select(Viewer viewer, Object parent, Object element) {
		// Skip to display a leaf that indicates '.svn' folder.
		if (element instanceof SVNFolder) {
			String path = ((ISVNFileItem) element).getName();
			if (path.equalsIgnoreCase(".svn")) {
				return false;
			}
		}
		return true;
	}
}