package com.interpress_project.modernshare.client.view.remotefs;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class RemoteFileTableLabelProvider implements ITableLabelProvider {
	private final SystemBase sb = SystemBase.getInstance();

	/**
	 * getColumnText
	 * @param element Object
	 * @param column_index int
	 * @return String
	 */
	public String getColumnText(Object element, int column_index) {
		switch (column_index) {
			default: {
				sb.getLogger().fatal("RemoteTable`掞ɕsȃCfbNXԍn܂B" + column_index);
				return "";
			}
			case 0: { // Name
				String s = ((ISVNFileItem) element).getName();
				try {
					s = URLDecoder.decode(s, AppKeys.ENCODING);
				}
				catch (UnsupportedEncodingException ex) {
					sb.getLogger().error("UnsupportedEncodingException decording string: ", ex);
				}
				return s;
			}
			case 1: { // Revision
				String s = String.valueOf(((ISVNFileItem) element).getRevision());
				return s;
			}
			case 2: { // LastChangedRevision
				String s = String.valueOf(((ISVNFileItem) element).getLastChangedRevision());
				return s;
			}
			case 3: // Author
				return ((ISVNFileItem) element).getLastCommitAuthor();

			case 4: {// LastChangedDate
				return ((ISVNFileItem) element).getLastChangedDate().toString();
			}
			case 5: {// Path
				String url = ((ISVNFileItem) element).getURL();
				URI u = null;
				try {
					u = new URI(url);
				}
				catch (URISyntaxException ex) {
					sb.getLogger().fatal("RemoteTable`掞URIϊɎs܂B(7)" + url);
					return "";
				}
				return u.getPath();
			}
			case 6: { // UUID
				return ((ISVNFileItem) element).getUUID();
			}
		}
	}

	/**
	 * addListener
	 * @param ilabelproviderlistener ILabelProviderListener
	 */
	public void addListener(ILabelProviderListener ilabelproviderlistener) {
	}

	/**
	 * dispose
	 */
	public void dispose() {
	}

	/**
	 * isLabelProperty
	 * @param obj Object
	 * @param s String
	 * @return boolean
	 */
	public boolean isLabelProperty(Object obj, String s) {
		return false;
	}

	/**
	 * removeListener
	 * @param ilabelproviderlistener ILabelProviderListener
	 */
	public void removeListener(ILabelProviderListener ilabelproviderlistener) {
	}

	/**
	 * getColumnImage
	 * @param element Object
	 * @param column_index int
	 * @return Image
	 */
	public Image getColumnImage(Object element, int column_index) {
		if (column_index != 0) {
			return null;
		}

		if (((ISVNFileItem) element).isDirectory()) {
			return ImageFactory.getInstance().getImage("rfolder");
		}
		else {
			String fileName = ((ISVNFileItem) element).getURL();
			return ImageFactory.getInstance().getAssociatedImageToFile(fileName);
		}
	}
}
