package com.interpress_project.modernshare.client.view.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class Checkout2Wizard extends Wizard {
	private final ViewManager vmgr = ViewManager.getInstance();
	private final LogEventSource logEventSource = LogEventSource.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();

	private CheckoutWelcomePage checkoutWelcomePage = new CheckoutWelcomePage();
	private CheckoutWizardPage2 checkoutWizardPage2 = new CheckoutWizardPage2();
	private CheckoutWizardPage3 checkoutWizardPage3 = new CheckoutWizardPage3();
	private CheckoutConfirmPage checkoutConfirmPage = new CheckoutConfirmPage();
	private SVNRoot root;

	/**
	 * CheckoutWizard
	 * @param list
	 */
	public Checkout2Wizard(SVNRoot root) {
		addPage(checkoutWelcomePage);
		addPage(checkoutWizardPage2);
		addPage(checkoutWizardPage3);
		addPage(checkoutConfirmPage);

		setNeedsProgressMonitor(true);
		setWindowTitle("zbgVbgEtH_ - `FbNAEgEEBU[h");

		this.root = root;
	}

	/**
	 * performFinish
	 */
	@Override
	public boolean performFinish() {
		/**
		 * Xbh̒`
		 */
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
				checkout(monitor);
			}
		};

		/**
		 * LXbh̎s
		 */
		try {
			logEventSource.fireEvent(new LogEvent(this, LogEventType.CLEAR));

			getContainer().run(true, true, op);
		}
		catch (InvocationTargetException ex) {
			logEventSource.fireEvent(new LogEvent(this, ex.getLocalizedMessage(), LogEventType.ERROR, ex));
			vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
			return false;
		}
		catch (InterruptedException ex) {
		}
		return true;
	}

	/**
	 * checkout
	 * @param monitor
	 * @throws InvocationTargetException
	 */
	private void checkout(IProgressMonitor monitor) throws InvocationTargetException {
		String path = checkoutWizardPage2.getPath();
		RootStatus status = checkoutWizardPage3.getStatus();
		boolean bPc2host = checkoutWizardPage3.getPc2host();
		String msg = null;

		PropertyManager propmgr = PropertyManager.getInstance();

		monitor.beginTask("", 5);

		// Step. 1
		msg = "zbgVbgEtH_Ƃč쐬tH_̓e`FbN܂B҂...";
		monitor.subTask(msg);
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));

		File targetfile = new File(path);
		String[] list = targetfile.list();
		if (list.length > 0) {
			boolean bAnswer = vmgr.getDialogManager().createYesNoMessageDialog("zbgVbgEtH_̊mF",
			  "w肳ꂽtH_" + path + "ɂ͊Ƀt@C݂Ă܂BSẴt@C폜Ă낵ł?");
			if (bAnswer) {
				msg = "tH_t@C폜Ă܂...";
				monitor.subTask(msg);
				logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
				try {
					FileUtils.cleanDirectory(targetfile);
				}
				catch (IOException ex) {
					throw new InvocationTargetException(ex, ex.getMessage());
				}
			}
			else {
				msg = "t@C݂tH_AzbgVbgEtH_Ƃč쐬邱Ƃ͂ł܂B";
				logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.ERROR));
				vmgr.getDialogManager().createInformationMessageDialog("tH_̊mF", msg);
				return;
			}
		}
		monitor.worked(1);

		SystemBase.getInstance().gc();

		// Step.2 
		monitor.subTask("`FbNAEgsĂ܂...");

		try {
			cmdmgr.execCommand(factory.createCheckoutCommand(path, root, status, bPc2host));
			monitor.worked(1);
		}
		catch (CommandException ex) {
			throw new InvocationTargetException(ex, ex.getMessage());
		}
		// Step.3
		msg = "Readmet@C쐬Ă܂...";
		monitor.subTask(msg);
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
		if (bPc2host) {
			new NoticeFile(path, propmgr.getIgnoreFilterList(), false).create();
		}
		else {
			new NoticeFile(path, propmgr.getIgnoreFilterList(), true).create();
		}
		monitor.worked(1);

		// Step.4
		msg = "ݒt@CۑĂ܂...";
		monitor.subTask(msg);
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
		LocalModelManager limgr = LocalModelManager.getInstance();
		limgr.addRoot(path, root.getName(), status, bPc2host);
		monitor.worked(1);

		// Step.5
		msg = "[JPCtbVĂ܂...";
		monitor.subTask(msg);
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
		//		new LocalRefreshAction(vmgr).run();
		cmdmgr.addCommand(factory.createLocalRefreshCommand());
		monitor.worked(1);

		monitor.done();
	}
}
