package com.interpress_project.modernshare.client.view.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;

/**
 * @stereotype Confirm page
 */
public class CheckoutConfirmPage extends WizardPage {
	private Label lblPath = null;
	private Label lblTagName = null;
	private Label lblActive = null;
	private Label lblPc2host = null;
	private SVNRoot root = null;
	private RootStatus status;
	private boolean bPc2host;

	/**
	 * CheckoutConfirmPage
	 */
	public CheckoutConfirmPage() {
		super("CheckoutConfirmPage");

		setTitle("zbgVbgEtH_̍쐬mF");
		setDescription("ȉ̓eŃzbgVbgEtH_쐬܂B");
		setPageComplete(true);
	}

	/**
	 * createControl
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);

		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 9;

		new Label(composite, SWT.NONE).setText("^O: ");
		lblTagName = new Label(composite, SWT.NONE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		lblTagName.setLayoutData(gd);

		new Label(composite, SWT.NONE).setText("zbgVbgEtH_: ");
		lblPath = new Label(composite, SWT.NONE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		lblPath.setLayoutData(gd);

		new Label(composite, SWT.NONE).setText("Ď: ");
		lblActive = new Label(composite, SWT.NONE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		lblActive.setLayoutData(gd);

		new Label(composite, SWT.NONE).setText("|V[: ");
		lblPc2host = new Label(composite, SWT.NONE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		lblPc2host.setLayoutData(gd);

		setControl(composite);
	}

	/**
	 * setPath
	 * @param path String
	 */
	public void setPath(String path) {
		lblPath.setText(path);
	}

	/**
	 * getPath
	 * @return
	 */
	public String getPath() {
		return lblPath.getText();
	}

	/**
	 * setTagName
	 * @param name
	 */
	public void setTagName(SVNRoot root) {
		if (root == null) {
			return;
		}
		this.root = root;
		lblTagName.setText(root.getName());
	}

	/**
	 * getTagName
	 * @return
	 */
	public SVNRoot getTagName() {
		return this.root;
	}

	/**
	 * setStatus
	 * @param status
	 */
	public void setStatus(RootStatus status) {
		this.status = status;
		switch (status) {
			case active:
				lblActive.setText("L");
				lblActive.setToolTipText("zbgVbgEtH_̓vpeBŎw肳ꂽɏ]ăf[^Z^ԂŎ܂B");
				break;

			case deactive:
			case disable:
				lblActive.setText("");
				lblActive.setToolTipText("zbgVbgEtH_ɑ΂鎩XV͍s܂B蓮Ńf[^Z^Ƃ̓sKv܂B");

				break;
		}
	}

	/**
	 * getStatus
	 * @return
	 */
	public RootStatus getStatus() {
		return status;
	}

	/**
	 * setPc2host
	 * @param b
	 */
	public void setPc2host(boolean b) {
		this.bPc2host = b;
		if (b) {
			lblPc2host.setText("zbgVbgEtH_(PC)  f[^Z^");
			lblPc2host.setToolTipText("ɃzbgVbgEtH_Ɋi[ꂽf[^Af[^Z^֍XV܂B");
		}
		else {
			lblPc2host.setText("f[^Z^  zbgVbgEtH_(PC)");
			lblPc2host.setToolTipText("f[^Z^Ɋi[f[^ŃzbgVbgEtH_XV܂BzbgVbgEtH_Ǎp̋Lɂꍇɕ֗łB");
		}
	}

	/**
	 * getPc2host
	 * @return
	 */
	public boolean getPc2host() {
		return bPc2host;
	}
}
