package com.interpress_project.modernshare.client.view.wizard;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;

/**
 * @stereotype Wizard page1
 */
public class ExportWizardPage1 extends WizardPage {
	private final ArrayList<ISVNFileItem> revlist;
	private Table tblRevision = null;
	private ISVNFileItem fileItem = null;

	/**
	 * RegWizardPage1
	 */
	public ExportWizardPage1(ArrayList<ISVNFileItem> revlist) {
		super("ExportWizardPage1");

		setTitle("f[^Z^̃[UtH_w");
		setDescription("f[^Z^Ƀ`FbNAEg\ȃ[UtH_(^O)܂Bȉ̃Xg`FbNAEg^OI܂B");
		PageComplete();

		this.revlist = revlist;
	}

	/**
	 * createControl
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 1;
		layout.verticalSpacing = 9;

		createTable(composite);

		for (int i = 0; i < revlist.size(); i++) {
			ISVNFileItem item = revlist.get(i);
			TableItem tableItem = new TableItem(tblRevision, SWT.NONE);
			String name = item.getName();
			try {
				name = URLDecoder.decode(name, AppKeys.ENCODING);
			}
			catch (UnsupportedEncodingException ex) {
			}
			tableItem.setText(new String[] { name, String.valueOf(item.getRevision()),
			    String.valueOf(item.getLastChangedRevision()), item.getLastCommitAuthor(),
			    item.getLastChangedDate().toString(), item.getURL(), item.getUUID() });
			tableItem.setData(item);
		}
		tblRevision.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}

			public void widgetSelected(SelectionEvent event) {
				Table table = (Table) event.getSource();
				TableItem[] items = table.getSelection();
				fileItem = (ISVNFileItem) items[0].getData();
				PageComplete();
			}
		});

		setControl(composite);
	}

	/**
	 * createTable
	 * @param composite
	 */
	private void createTable(Composite composite) {
		Font font = new Font(composite.getDisplay(), "MS UI Gothic", 9, SWT.NORMAL);

		Label label = new Label(composite, SWT.NULL);
		label.setText("^OXgꗗ:");

		tblRevision = new Table(composite, SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.VIRTUAL);
		GridData gd = new GridData(GridData.FILL_BOTH);
		tblRevision.setLayoutData(gd);
		tblRevision.setFont(font);
		tblRevision.setHeaderVisible(true);

		TableColumn column = null;
		column = new TableColumn(tblRevision, SWT.LEFT);
		column.setText("O");
		column.setWidth(180);

		column = new TableColumn(tblRevision, SWT.RIGHT);
		column.setText("rW");
		column.setWidth(76);

		column = new TableColumn(tblRevision, SWT.RIGHT);
		column.setText("rW(ŏIύX)");
		column.setWidth(120);
		tblRevision.setSortColumn(column);

		column = new TableColumn(tblRevision, SWT.LEFT);
		column.setText("ύX");
		column.setWidth(80);

		column = new TableColumn(tblRevision, SWT.LEFT);
		column.setText("XV");
		column.setWidth(180);

		column = new TableColumn(tblRevision, SWT.LEFT);
		column.setText("i[pX(f[^Z^)");
		column.setWidth(180);

		column = new TableColumn(tblRevision, SWT.LEFT);
		column.setText("UUID");
		column.setWidth(240);
	}

	/**
	 * getISVNFileItem
	 * @return
	 */
	public ISVNFileItem getISVNFileItem() {
		return this.fileItem;
	}

	/**
	 * PageComplete
	 */
	protected void PageComplete() {
		setErrorMessage(null);
		if (fileItem == null) {
			setPageComplete(false);
		}
		else {
			setPageComplete(true);
		}
	}

	/**
	 * getNextPage
	 * @return IWizardPage
	 */
	public IWizardPage getNextPage() {
		ExportWizardPage2 page2 = (ExportWizardPage2) getWizard().getPage("ExportWizardPage2");
		page2.setISVNFileItem(fileItem);
		return super.getNextPage();
	}
}
