package com.interpress_project.modernshare.client.view.wizard;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 * @stereotype Wizard page2
 */
public class ExportWizardPage2 extends WizardPage {
	private Text txtPath = null;
	private Button button = null;
	private String localfileName = null;
	private ISVNFileItem fileItem = null;

	/**
	 * RegWizardPage1
	 */
	public ExportWizardPage2() {
		super("ExportWizardPage2");

		setTitle("ۑtH_̎w");
		setDescription("o\[X̕ۑtH_w肵܂B");
		setPageComplete(false);
	}

	/**
	 * Creates the controls for this page
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;

		Label label = new Label(composite, SWT.NULL);
		label.setText("tH_:");
		/**
		 * tH_pX̓̓{bNX
		 */
		txtPath = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		txtPath.setLayoutData(gd);
		txtPath.addModifyListener(new ModifyListener() {
			// Validate a file path.
			public void modifyText(ModifyEvent modifyEvent) {
				pageIncomplete(null);
				String path = txtPath.getText();
				LocalModelManager localmgr = LocalModelManager.getInstance();
				if (localmgr.isPathOverwrapped(path)) {
					pageIncomplete("̊ĎΏۃtH_ƏdĂ܂B");
					return;
				}
				pageComplete();
			}
		});

		/**
		 * tH_pX̃tH_w{^
		 */
		button = new Button(composite, SWT.NONE);
		button.setText("...");
		button.setFocus();
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent selectionEvent) {
				ViewManager vmgr = ViewManager.getInstance();
				String name = null;
				try {
					name = URLDecoder.decode(fileItem.getName(), AppKeys.ENCODING);
				}
				catch (UnsupportedEncodingException ex) {
					ex.printStackTrace();
				}
				if (fileItem.isDirectory()) {
					localfileName = vmgr.getDialogManager().createDirectoryDialog("WJtH_̎w", name);
				}
				else {
					localfileName = vmgr.getDialogManager().openSaveDialog(name);
				}
				if (localfileName != null) {
					txtPath.setText(localfileName);
				}
			}
		});
		setControl(composite);
	}

	/**
	 * pageIncomplete
	 * @param msg
	 */
	private void pageIncomplete(String msg) {
		setErrorMessage(msg);
		setPageComplete(false);
	}

	/**
	 * pageComplete
	 */
	private void pageComplete() {
		setErrorMessage(null);
		setPageComplete(txtPath.getText().length() > 0);
	}

	public void setISVNFileItem(ISVNFileItem fileItem) {
		this.fileItem = fileItem;
	}

	/**
	 * getLocalFileName
	 * @return
	 */
	public String getLocalFileName() {
		return localfileName;
	}

	/**
	 * getNextPage
	 * @return IWizardPage
	 */
	public IWizardPage getNextPage() {
		ExportConfirmPage confirmPage = (ExportConfirmPage) getWizard().getPage("ExportConfirmPage");
		confirmPage.setPath(localfileName);
		confirmPage.setRevision(fileItem.getLastChangedRevision());
		confirmPage.setModified(fileItem.getLastChangedDate());
		return super.getNextPage();
	}
}
