package com.interpress_project.modernshare.client.view.wizard;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

public class RemoteExportWizard extends Wizard {
	private final ViewManager vmgr = ViewManager.getInstance();
	private final LogEventSource logEventSource = LogEventSource.getInstance();
	private ExportWelcomePage exportWelcomePage = new ExportWelcomePage();
	private ExportWizardPage2 exportWizardPage2 = new ExportWizardPage2();
	private ExportConfirmPage exportConfirmPage = new ExportConfirmPage();
	private ISVNFileItem fileItem;

	/**
	 * LocalExportWizard
	 * @param revlist
	 */
	public RemoteExportWizard(ISVNFileItem fileItem) {
		addPage(exportWelcomePage);
		exportWizardPage2.setISVNFileItem(fileItem);
		addPage(exportWizardPage2);
		addPage(exportConfirmPage);

		setNeedsProgressMonitor(true);
		setWindowTitle("zbgVbgEtH_ - oEBU[h");

		this.fileItem = fileItem;
	}

	/**
	 * performFinish
	 */
	@Override
	public boolean performFinish() {
		/**
		 * Xbh̒`
		 */
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
				export(monitor);
			}
		};
		/**
		 * LXbh̎s
		 */
		try {
			//			logEventSource.addEventListener(ViewManager.getInstance());
			getContainer().run(true, true, op);
		}
		catch (InvocationTargetException ex) {
			logEventSource.fireEvent(new LogEvent(this, ex.getLocalizedMessage(), LogEventType.ERROR, ex));
			vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
			return false;
		}
		catch (InterruptedException ex) {
		}
		finally {
			//			logEventSource.removeEventListener(ViewManager.getInstance());
		}
		return true;
	}

	/**
	 * export
	 * @param monitor
	 * @throws InvocationTargetException
	 */
	private void export(IProgressMonitor monitor) throws InvocationTargetException {
		String path = exportWizardPage2.getLocalFileName();

		try {
			monitor.beginTask("f[^̎oJn܂...", 1);

			SVNCommandFactory factory = SVNCommandFactory.getInstance();
			ISVNCommand command = factory.createLocalExportCommand(fileItem, path);
			SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
			cmdmgr.execCommand(command);

			monitor.worked(1);
		}
		catch (CommandException ex) {
			logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
		}
		finally {
			monitor.done();
		}
	}
}
