package com.interpress_project.modernshare.ipcommon;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtilImpl {

	/**
	 * DateUtilImpl
	 */
	public DateUtilImpl() {
	}

	/**
	 * getDateAsString
	 * @param date Date
	 * @return String
	 */
	public String getDateAsString(Date date) {
		DateFormat df = DateFormat.getDateInstance(DateFormat.LONG);
		return df.format(date);
	}

	/**
	 * getDateAsFullString
	 * @param date Date
	 * @return String
	 */
	public String getDateAsFullString(Date date) {
		DateFormat df = DateFormat.getDateInstance(DateFormat.FULL);
		return df.format(date);
	}

	/**
	 * getDateTimeAsString
	 * @param date Date
	 * @return String
	 */
	public String getDateTimeAsString(Date date) {
		DateFormat df = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG);
		return df.format(date);
	}

	/**
	 * getDateTimeAsFullString
	 * @param date Date
	 * @return String
	 */
	public String getDateTimeAsFullString(Date date) {
		DateFormat df = DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL);
		return df.format(date);
	}

	/**
	 * getDateTimeAsDecimal
	 * @param date
	 * @return
	 */
	public String getDateTimeAsDecimal(Date date) {
		DateFormat df = new SimpleDateFormat("MMddyyyy.HHmmss");
		return df.format(date);
	}
}
