package com.interpress_project.modernshare;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.AccountManager;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.serveradm.ORBManager;
import com.interpress_project.modernshare.serveradm.SVNRepositoryManager;
import com.interpress_project.modernshare.svnserver.SVNServeManager;
import com.interpress_project.modernshare.svnserver.ServerManager;

/**
 * @stereotype Main Class
 */
public class Container {
	private final SystemBase sb = SystemBase.getInstance();
	private ORBManager orbmgr;

	/**
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 */
	private ServerManager svnmgr;

	/**
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 */
	private SVNRepositoryManager repmgr;

	/**
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 */
	private AccountManager acctmgr;

	/**
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 */
	private SVNServeManager svnsrvmgr;

	/**
	 * Container
	 */
	public Container(String[] args) {
		sb.setLoggerInfo(AppKeys.ServerProgramName, AppKeys.LogFilename);

		sb.getLogger().info("HotShot Server is being started...");
		/**
		 * Parse command options.
		 */
		String propfile = AppKeys.ServerPropFilename;
		for (int i = 0; i < args.length; i++) {
			if ("-propfile".equalsIgnoreCase(args[i])) {
				propfile = args[++i];
			}
		}
		PropertyManager.getInstance().initialize(propfile);
		repmgr = new SVNRepositoryManager();
		acctmgr = new AccountManager();

		/**
		 * Shutdown hook.
		 */
		Runtime.getRuntime().addShutdownHook(new ShutdownHook());
	}

	/**
	 * run
	 */
	private void run(String[] args) {
		orbmgr = new ORBManager(args, acctmgr, repmgr);
		orbmgr.start();
		try {
			orbmgr.join(1000);
		}
		catch (InterruptedException ex) {
		}

		svnmgr = new ServerManager();
		svnmgr.start();
		try {
			svnmgr.join(1000);
		}
		catch (InterruptedException ex) {
		}

		svnsrvmgr = new SVNServeManager();
		svnsrvmgr.start();
		try {
			svnsrvmgr.join(1000);
		}
		catch (InterruptedException ex) {
		}

		sb.getLogger().info("HotShot Server is ready.");		
	}

	/**
	 * main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		new Container(args).run(args);

		while (true) {
			try {
				Thread.sleep(30 * 1000);
			}
			catch (Exception ex) {
				break;
			}
		}
	}

	/**
	 * stop
	 */
	public static void stop() {
		SystemBase.getInstance().getLogger().warn("Service termination hook called.");
		System.exit(0);		
	}
	
	/**
	 * ShutdownHook
	 * @author mshimada
	 */
	private class ShutdownHook extends Thread {
		private final SystemBase sb = SystemBase.getInstance();

		/**
		 * run
		 */
		public void run() {
			sb.getLogger().info("HotShot Server shutdown started.");

			if (svnmgr != null) {
				svnmgr.shutdown();
			}
			if (orbmgr != null) {
				orbmgr.shutdown();
			}
			if (svnsrvmgr != null) {
				svnsrvmgr.dispose();
			}
			sb.getLogger().info("HotShot Server shutdown finished.");
		}
	}
}
