package com.interpress_project.modernshare.serveradm;

import org.jacorb.security.sas.GssUpContext;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.AccountManager;

public final class ListGssUpContext extends GssUpContext {
	private SystemBase sb = SystemBase.getInstance();

	/**
	 * ListGssUpContext
	 */
	public ListGssUpContext() {
	}

	/**
	 * validateContext
	 */
	public boolean validateContext(ORB orb, Codec codec, byte[] contextToken) {
		boolean b = super.validateContext(orb, codec, contextToken);
		if (b) {
			return validateUsernamePassword(initialContextToken.username, initialContextToken.password);
		}
		return b;
	}

	/**
	 * validateUsernamePassword
	 * @param uname
	 * @param pswd
	 * @return
	 */
	private boolean validateUsernamePassword(byte[] uname, byte[] pswd) {
		sb.getLogger().debug("Enter validateUsernamePassword()");

		String username = new String(uname);
		String password = new String(pswd);

		return AccountManager.authenticate(username, password);
	}
}
