//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "PUUserDefaults.h"
#import "PUMacros.h"

static PUUserDefaults* s_self = nil;

@implementation PUUserDefaults

+(id) standardUserDefaults
{
	if (!s_self) {
		s_self = [[PUUserDefaults alloc] init];
	}
	return s_self;
}

-(id) init
{
	if (self = [super init]) {
		NSString* path = NSHomeDirectory();
		path = [path stringByAppendingPathComponent:@"Library/Preferences"];
		path = [path stringByAppendingPathComponent:BUNDLE_IDENTIFIER];
		path = [path stringByAppendingPathExtension:@"plist"];
		m_path = [[NSString alloc] initWithString:path];
		m_plist = [NSMutableDictionary dictionaryWithContentsOfFile:m_path];
		if (m_plist) {
			[m_plist retain];
		} else {
			m_plist = [[NSMutableDictionary alloc] init];
		}
	}
	return self;
}

-(void) dealloc
{
	[m_path release];
	[m_plist release];
	[super dealloc];
}

-(void) setObject:(id)obj forKey:(id)key
{
	if (obj && key) {
		[m_plist setObject:obj forKey:key];
	}
}

-(id) objectForKey:(id)key
{
	if (key) {
		return [m_plist objectForKey:key];
	}
	return nil;
}

-(void) removeObjectForKey:(id)key
{
	if (key) {
		[m_plist removeObjectForKey:key];
	}
}

-(BOOL) synchronize
{
	return [m_plist writeToFile:m_path atomically:YES];
}

@end
