//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#import "KeychainAccessor.h"

@implementation KeychainAccessor

+(void) changeInternetPassword:(NSString*)password account:(NSString*)account url:(NSURL*)url port:(int)port protocol:(SecProtocolType)protocol authenticationType:(SecAuthenticationType)authenticationType
{
	NSString* server = [url host];
	NSString* path = [url path];
	
	NSString* user = [url user];
	if (!IS_NULL_STR(user)) {
		server = [NSString stringWithFormat:@"%@@%@", user, server];
	}
	
	if (IS_NULL_STR(account) || IS_NULL_STR(password) || IS_NULL_STR(server) || IS_NULL_STR(path)) {
		return;
	}
	
	const char* accountUTF8 = [account UTF8String];
	const char* passwordUTF8 = [password UTF8String];
	const char* serverUTF8 = [server UTF8String];
	const char* pathUTF8 = [path UTF8String];
	
	SecKeychainItemRef item = nil;
	// 既存かどうか
	OSStatus err = SecKeychainFindInternetPassword(NULL, strlen(serverUTF8), serverUTF8, 0, NULL, strlen(accountUTF8), accountUTF8, strlen(pathUTF8), pathUTF8, port, protocol, authenticationType, NULL, NULL, &item);
	if (item) {
		// 既存なら変更
		SecKeychainAttribute attr[] = {
			{ kSecAccountItemAttr, strlen(accountUTF8), (char*)accountUTF8 }
		};
		const SecKeychainAttributeList attributes = { sizeof(attr) / sizeof(attr[0]), attr };
		err = SecKeychainItemModifyAttributesAndData(item, &attributes, strlen(passwordUTF8), (void*)passwordUTF8);
	} else {
		// なければ作成	
		err = SecKeychainAddInternetPassword(NULL, strlen(serverUTF8), serverUTF8, 0, NULL, strlen(accountUTF8), accountUTF8, strlen(pathUTF8), pathUTF8, port, protocol, authenticationType, strlen(passwordUTF8), (const void*)passwordUTF8, &item);
	}
	
	if (item) {
		CFRelease(item);
	}
}

+(void) changeInternetPassword:(NSString*)password account:(NSString*)account url:(NSURL*)url
{
	SecProtocolType protocol;
	int port;
	SecAuthenticationType authenticationType = kSecAuthenticationTypeDefault;
	NSString* scheme = [url scheme];
	if ([scheme isEqualTo:@"http"]) {
		protocol = kSecProtocolTypeHTTP;
		port = 80;
	} else if ([scheme isEqualTo:@"https"]) {
		protocol = kSecProtocolTypeHTTPS;
		port = 80;
	} else if ([scheme isEqualTo:@"ftp"]) {
		protocol = kSecProtocolTypeFTP;
		port = 23;
	} else {
		return;
	}
	[KeychainAccessor changeInternetPassword:password account:account url:url port:port protocol:protocol authenticationType:authenticationType];
}

+(NSString*) getInternetPassword:(NSString*)account url:(NSURL*)url port:(int)port protocol:(SecProtocolType)protocol authenticationType:(SecAuthenticationType)authenticationType
{
	NSString* server = [url host];
	NSString* path = [url path];
	
	NSString* user = [url user];
	if (!IS_NULL_STR(user)) {
		server = [NSString stringWithFormat:@"%@@%@", user, server];
	}	
	
	UInt32 passLen;
	char* passwordUTF8 = nil;
	const char* accountUTF8 = [account UTF8String];
	const char* serverUTF8 = [server UTF8String];
	const char* pathUTF8 = [path UTF8String];
	if (!(accountUTF8 && serverUTF8 && strlen(accountUTF8) > 0 && strlen(serverUTF8) > 0)) {	
		return nil;
	}
	
	OSStatus err = SecKeychainFindInternetPassword(NULL, strlen(serverUTF8), serverUTF8, 0, NULL, strlen(accountUTF8), accountUTF8, strlen(pathUTF8), pathUTF8, port, protocol, authenticationType, &passLen, (void*)&passwordUTF8, NULL);
	if (err || !passwordUTF8) {
		return nil;
	}
	// null終端文字列とは限らないので
	passwordUTF8[passLen] = '\0';
	return [NSString stringWithUTF8String:passwordUTF8];
}

+(NSString*) getInternetPassword:(NSString*)account url:(NSURL*)url
{
	SecProtocolType protocol;
	int port;
	SecAuthenticationType authenticationType = kSecAuthenticationTypeDefault;
	NSString* scheme = [url scheme];
	if ([scheme isEqualTo:@"http"]) {
		protocol = kSecProtocolTypeHTTP;
		port = 80;
	} else if ([scheme isEqualTo:@"https"]) {
		protocol = kSecProtocolTypeHTTPS;
		port = 80;
	} else if ([scheme isEqualTo:@"ftp"]) {
		protocol = kSecProtocolTypeFTP;
		port = 23;
	}
	return [KeychainAccessor getInternetPassword:account url:url port:port protocol:protocol authenticationType:authenticationType];
}


@end
