//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "FotolifeService.h"
#import "Fotolife.h"
#import "PUCommon.h"

@implementation FotolifeService

-(id) init
{
	if (self = [super init]) {
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.account"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.password"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.album"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.title"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.keyword"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.comment"];

		[self setValue:[NSURL URLWithString:FOTOLIFE_API_PATH] forKeyPath:@"param.keychainURL"];
		[self setValue:@"Fotolife" forKeyPath:@"param.saveKey"];

		[self setValue:
		 [NSArray arrayWithObjects:
		  [NSNumber numberWithInt:kPUImageFormat_Jpeg], 
		  [NSNumber numberWithInt:kPUImageFormat_Png], 
		  [NSNumber numberWithInt:kPUImageFormat_Gif], 
		  nil] 
			forKeyPath:@"spec.formats"];
	}
	return self;
}

-(void) dealloc
{
	[super dealloc];
}

#pragma mark ___ PUService protocol ___

-(NSString*) title
{
	return LOCALIZED(@"Hatena Fotolife");
}

-(PURequest*) createRequest:(PUPhoto*)photo
{
	return [[[Fotolife_AtomPost alloc] init] autorelease];
}

-(NSDictionary*) convertAttributes
{
	return nil;
}

-(NSURL*) URLForLastUpload:(NSArray*)responses
{
	NSString* path = nil;
	if ([responses count] == 0) {
		path = [NSString stringWithFormat:@"%@%@/", FOTOLIFE_API_PATH, [self valueForKeyPath:@"param.account"]];
	} else {
		if ([responses count] == 1) {
			HFPhoto* photo = [responses objectAtIndex:0];
			if ([photo isKindOfClass:[HFPhoto class]]) {
				/* 写真ページそのもの */
				path = [photo valueForKey:@"imageurl"];
			}
		} else {
			path = [NSString stringWithFormat:@"%@%@/", FOTOLIFE_API_PATH, [self valueForKeyPath:@"param.account"]];
		}
	}
	if (path) {
		return [NSURL URLWithString:path];
	}
	return nil;
}

-(void) login
{
	NSString* account = [self valueForKeyPath:@"param.account"];
	NSString* password = [self valueForKeyPath:@"param.password"];
	if (IS_NULL_STR(account) || IS_NULL_STR(password)) {
		return;
	}
	[FotolifeRequest setUsername:account];
	[FotolifeRequest setPassword:password];
}

@end
