//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "Fotolife_AtomPost.h"
#import "PUCommon.h"
#import "HFPhoto.h"
#import "NSXMLElement-ex.h"
#import "NSData-Base64Extensions.h"

@implementation Fotolife_AtomPost

-(id) init
{
	if (self = [super initWithURL:[NSURL URLWithString:FOTOLIFE_REST_PATH(@"atom/post")] withMethod:@"POST"]) {
	}
	return self;
}

-(void) start
{
	NSURL* fileUrl = [self valueForKeyPath:@"param.fileUrl"];
	NSString* title = [self valueForKeyPath:@"param.title"];
	NSString* contentType = [self valueForKeyPath:@"param.contentType"];
	
	if (!(fileUrl && [fileUrl isFileURL] && contentType)) {
		return;
	}
	
	NSXMLElement* root = [[NSXMLElement alloc] initWithName:@"entry" URI:@"http://purl.org/atom/ns#"];
	if (title) {
		NSXMLElement* element = [[NSXMLElement alloc] initWithName:@"title" stringValue:title];
		[root addChild:element];
		[element release];
	}
	NSXMLElement* content = [[NSXMLElement alloc] initWithName:@"content"];
	[content setAttributeValue:@"base64" forName:@"mode"];
	[content setAttributeValue:contentType forName:@"type"];
	NSData* data = [[NSData alloc] initWithContentsOfURL:fileUrl];
	[content setStringValue:[data encodeBase64WithNewlines:NO]];
	[root addChild:content];
	[data release];
	[content release];
	
	NSXMLDocument* doc = [[NSXMLDocument alloc] initWithRootElement:root];
	[doc setVersion:@"1.0"];
	[doc setCharacterEncoding:@"utf-8"];
	[root release];

//	NSLog(@"%@", [root description]);
	CFHTTPMessageSetBody(m_message, (CFDataRef)[doc XMLData]);
	CFHTTPMessageSetHeaderFieldValue(m_message, CFSTR("Content-Length"), (CFStringRef)[NSString stringWithFormat:@"%d", [[doc XMLData] length]]);
	[doc release];

	[super start];
}

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
		}
		return xml;
	}
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSError* err = nil;
		NSEnumerator* enume = [[[[xml rootElement] nodeForXPath:@"/entry" error:&err] children] objectEnumerator];
		if (!err) {
			NSXMLElement* child;
			HFPhoto* photo = [[HFPhoto alloc] init];
			while (child = [enume nextObject]) {
				if ([[child name] hasPrefix:@"hatena"]) {
					[photo setValue:[child objectValue] forKey:[[child name] substringFromIndex:7]];
				} else {
					[photo setValue:[child objectValue] forKey:[child name]];
				}
			}
			*error = nil;
			return [photo autorelease];
		} else {
			*error = err;
		}
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
	}
	return nil;
}

@end
