//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "iPhotoUploader.h"
#import "PUMacros.h"
#import "PUMultiRequest.h"
#import "PUServiceManager.h"
#import "PUPhoto.h"

#import "PhotoZou.h"
#import "Fotolife.h"
#import "Flickr.h"
#import "Mixi.h"

@implementation iPhotoUploader

-(void) serviceManagerDidFinishExport:(PUServiceManager*)manager
{
	[[m_exMgr exportController] cancel:nil];
}

#pragma mark ___ ExportPluginProtocol ___

-(id) initWithExportImageObj:(id)fp8
{
	if (self = [super init]) {
		[NSBundle loadNibNamed:@"iPhotoUploader" owner:self];
		
		m_exMgr = fp8;
		m_srvMgr = [[PUServiceManager alloc] init];
		
		NSString* about = [NSString stringWithFormat:@"v%@ Copyright (c) 2008-2009 itok (http://itok.jp/)", [[[NSBundle bundleWithIdentifier:BUNDLE_IDENTIFIER] infoDictionary] objectForKey:@"CFBundleVersion"]];
		[self setValue:about forKey:@"about"];
	}
	return self;
}

-(void) dealloc
{
	[m_srvMgr release];	
	[super dealloc];
}

-(id) settingsView
{
	return o_box;
}

-(id) firstView
{
	return o_box;
}

-(void) viewWillBeActivated
{
	if ([[o_view subviews] count] == 0) {
		[o_view addSubview:[m_srvMgr view]];	
	}
}

-(void) viewWillBeDeactivated
{
}

-(id) requiredFileType
{
	return @"";
}

-(BOOL) wantsDestinationPrompt
{
	return NO;
}

-(id) getDestinationPath
{
	return @"";
}

-(id) defaultFileName
{
	return @"";
}

-(id) defaultDirectory
{
	return NSHomeDirectory();
}

-(BOOL) treatSingleSelectionDifferently
{
	return NO;
}

-(BOOL) handlesMovieFiles
{
	return NO;
}

-(BOOL) validateUserCreatedPath:(id)fp8
{
	return YES;
}

-(void) clickExport
{
}

-(void) startExport:(id)fp8
{
	[m_srvMgr startExport:[PUPhoto photosWithExManager:m_exMgr] delegate:self];
}

-(void) performExport:(id)fp8
{
}

-(void*) progress
{
	return (void*)@"";
}

-(void) lockProgress
{
}

-(void) unlockProgress
{
}

-(void) cancelExport
{
}

-(id) name
{
	return LOCALIZED(@"iPhotoUploader");
}

@end
