//
// HTTPURLResponse.cpp
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/HTTPURLResponse.h>

namespace Raym
{

#define RELEASE(P1)         \
    if ((P1) != NULL)       \
    {                       \
        (P1)->release();    \
        (P1) = NULL;        \
    }

HTTPURLResponse::HTTPURLResponse()
{
    DebugLog2("HTTPURLResponse::HTTPURLResponse()");

    _statusCode = 0;
    _HTTPVersion = NULL;
    _headerFields = NULL;
}

HTTPURLResponse::~HTTPURLResponse()
{
    _statusCode = 0;
    RELEASE(_HTTPVersion);
    RELEASE(_headerFields);

    DebugLog2("HTTPURLResponse::~HTTPURLResponse()\n");
}

HTTPURLResponse *HTTPURLResponse::alloc()
{
    DebugLog2("HTTPURLResponse::alloc()");

    return new HTTPURLResponse();
}

HTTPURLResponse *HTTPURLResponse::initWithURL(URL *url, Integer statusCode, String *HTTPVersion, Dictionary *headerFields)
{
    DebugLog2("HTTPURLResponse::initWithURL()");

    if ((url == NULL) || (statusCode == 0) || (HTTPVersion == NULL) || (headerFields == NULL))
    {
        DebugLog3("error: parameter check NG.");
        return NULL;
    }

    String *MIMEType = NULL;
    long long content_length = URLResponseUnknownLength;
    String *encoding = NULL;

    Array *keys = headerFields->allKeys();
    for (uint i = 0; i < keys->count(); ++i)
    {
        String *key = (String *)keys->objectAtIndex(i);
        String *val = headerFields->stringForKey(key);

        if (key->lowercaseString()->isEqualToString("content-type"))
        {
#ifdef _WIN32
            char *value = _strdup(val->lowercaseString()->cString());
#else
            char *value = strdup(val->lowercaseString()->cString());
#endif
            if (value != NULL)
            {
                char *p = strchr(value, ';');
                if (p != NULL)
                {
                    *p = '\0';
                    ++p;
                    while (*p == ' ')
                    {
                        ++p;
                    }
                }
                MIMEType = String::stringWithUTF8String(value);
                if (p != NULL)
                {
                    if (MIMEType->isEqualToString("text/html"))
                    {
                        if (strncmp("charset=", p, 8) == 0)
                        {
                            encoding = String::stringWithUTF8String(&p[8]);
                        }
                    }
                }
                free(value);
            }
        }
        if (key->lowercaseString()->isEqualToString("content-length"))
        {
            long long len = atoll(val->cString());
            char tmp[32];
#ifdef _WIN32
            sprintf_s(tmp, sizeof(tmp), "%lld", len);
#else
            sprintf(tmp, "%lld", len);
#endif
            if (strcmp(tmp, val->cString()) == 0)
            {
                content_length = len;
            }
        }
    }

    if (MIMEType == NULL)
    {
        MIMEType = String::stringWithUTF8String("text/plain");
    }
    if (encoding == NULL)
    {
        encoding = String::stringWithUTF8String("us-ascii");
    }

    URLResponse *ret = URLResponse::initWithURL(url, MIMEType, content_length, encoding);
    if (ret == NULL)
    {
        return NULL;
    }

    _statusCode = statusCode;
    _HTTPVersion = HTTPVersion;
    _HTTPVersion->retain();
    _headerFields = headerFields;
    _headerFields->retain();

    return this;
}

Integer HTTPURLResponse::statusCode()
{
    DebugLog2("HTTPURLResponse::statusCode()");

    return _statusCode;
}

Dictionary *HTTPURLResponse::allHeaderFields()
{
    DebugLog2("HTTPURLResponse::allHeaderFields()");

    return _headerFields;
}

const char *HTTPURLResponse::className()
{
    return "HTTPURLResponse";
}

} // Raym
