//
// Number.cpp
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/Number.h>

namespace Raym
{

Number::Number()
{
    DebugLog2("Number::Number()");

    _type = TYPE_Unkonown;
    _value._unsignedLongLongValue = 0;
}

Number::~Number()
{
    DebugLog2("Number::~Number()");
}

Number *Number::alloc()
{
    DebugLog2("Number::alloc()");
    return new Number();
}

Number *Number::initWithBool(bool value)
{
    DebugLog2("Number::initWithBool()");

    _type = TYPE_Bool;
    _value._boolValue = value;
    return this;
}

Number *Number::initWithInt(int value)
{
    DebugLog2("Number::initWithInt()");

    _type = TYPE_Int;
    _value._intValue = value;
    return this;
}

Number *Number::initWithUnsignedInt(uint value)
{
    DebugLog2("Number::initWithUnsignedInt()");

    _type = TYPE_UnsignedInt;
    _value._unsignedIntValue = value;
    return this;
}

Number *Number::retain()
{
    DebugLog2("Number::retain()");

    Object::retain();
    return this;
}

Number *Number::autorelease()
{
    DebugLog2("Number::autorelease()");

    Object::autorelease();
    return this;
}

bool Number::boolValue()
{
    DebugLog2("Number::boolValue()");

    return _value._boolValue;
}

int Number::intValue()
{
    DebugLog2("Number::intValue()");

    return _value._intValue;
}

uint Number::unsignedIntValue()
{
    DebugLog2("Number::unsignedIntValue()");

    return _value._unsignedIntValue;
}

String *Number::description()
{
    DebugLog2("Number::description()");

    switch (_type)
    {
    case TYPE_Bool:
        return String::stringWithUTF8String(_value._boolValue ? "true" : "false");

    case TYPE_Char:
    case TYPE_Double:
    case TYPE_Float:
        break;

    case TYPE_Int:
        return String::stringWithFormat(String::stringWithUTF8String("%d"), _value._intValue);

    case TYPE_Integer:
    case TYPE_Long:
    case TYPE_LongLong:
    case TYPE_Short:
    case TYPE_UnsignedChar:
        break;

    case TYPE_UnsignedInt:
        return String::stringWithFormat(String::stringWithUTF8String("%u"), _value._intValue);
        break;

    case TYPE_UnsignedInteger:
    case TYPE_UnsignedLong:
    case TYPE_UnsignedLongLong:
    case TYPE_UnsignedShort:
    case TYPE_Unkonown:
    default:
        break;
    }
 
    return String::stringWithFormat(String::stringWithCString("<Number: 0x%08x>", UTF8StringEncoding), this);
}


const char *Number::className()
{
    return "Number";
}

} // Raym
