﻿//
//
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/Raym.h>

namespace Raym
{

Pipe::Pipe()
{
    DebugLog2("Pipe::Pipe()");

    _fileHandleForReading = NULL;
    _fileHandleForWriting = NULL;
}

Pipe::~Pipe()
{
    RELEASE(_fileHandleForReading);
    RELEASE(_fileHandleForWriting);

    DebugLog2("Pipe::~Pipe()");
}

Pipe *Pipe::alloc()
{
    DebugLog2("Pipe::alloc()");

    return new Pipe();
}

Pipe *Pipe::init()
{
    DebugLog2("Pipe::init()");

    SECURITY_ATTRIBUTES sa;
    sa.nLength              = sizeof(sa);
    sa.lpSecurityDescriptor = 0;
    sa.bInheritHandle       = TRUE;

    HANDLE read;
    HANDLE write;
    if (!CreatePipe(&read, &write, &sa, 0))
    {
        release();
        return NULL;
    }

    _fileHandleForReading = FileHandle::fileHandleWithHANDLE(read);
    _fileHandleForReading->retain();
    _fileHandleForWriting = FileHandle::fileHandleWithHANDLE(write);
    _fileHandleForWriting->retain();

    return this;
}

FileHandle *Pipe::fileHandleForReading()
{
    DebugLog2("Pipe::fileHandleForReading()");

    return _fileHandleForReading;
}

FileHandle *Pipe::fileHandleForWriting()
{
    DebugLog2("Pipe::fileHandleForWriting()");

    return _fileHandleForWriting;
}

const char *Pipe::className()
{
    return "Pipe";
}

} // Raym
