//
// Runtime.h
//

#ifndef __RAYM_RUNTIME_H__
#define __RAYM_RUNTIME_H__

#include <limits.h>

namespace Raym
{

#if __LP64__ || (TARGET_OS_EMBEDDED && !TARGET_OS_IPHONE) || TARGET_OS_WIN32 || NS_BUILD_32_LIKE_64
typedef long Integer;
typedef unsigned long UInteger;
#else
typedef int Integer;
typedef unsigned int UInteger;
#endif

#define IntegerMax    LONG_MAX
#define IntegerMin    LONG_MIN
#define UIntegerMax   ULONG_MAX

#define INTEGER_DEFINED 1

enum {
   OrderedAscending = -1,
   OrderedSame,
   OrderedDescending
};
typedef Integer ComparisonResult;
typedef double TimeInterval;

typedef struct _Range {
      UInteger location;
      UInteger length;
} Range;

enum {
   NotFound = IntegerMax 
};

} // Raym
#endif // __RAYM_RUNTIME_H__