﻿//
// HTTPResponse.cpp
//

#include "net/HTTPResponse.h"

using namespace Raym;

namespace NET
{

HTTPResponse::HTTPResponse()
{
    _version = NULL;
    _status  = 0;
    _reason  = NULL;
    _message = NULL;
}

HTTPResponse::~HTTPResponse()
{
    RELEASE(_version);
    RELEASE(_reason);
    RELEASE(_message);
}

HTTPResponse *HTTPResponse::alloc()
{
#if 0
    HTTPResponse *result;
    result = new HTTPResponse();
    result->init();
    result->autorelease();
    return result;
#else
    return new HTTPResponse();
#endif
}

HTTPResponse *HTTPResponse::init()
{
    return this;
}

void HTTPResponse::setVersion(String *version)
{
    SET_METHOD(_version, version);
}

String *HTTPResponse::version()
{
    return _version;
}

void HTTPResponse::setStatus(int status)
{
    _status = status;
}

int HTTPResponse::status()
{
    return _status;
}

void HTTPResponse::setReason(String *reason)
{
    SET_METHOD(_reason, reason);
}

String *HTTPResponse::reason()
{
    return _reason;
}

void HTTPResponse::setMessage(InternetTextMessage *message)
{
    SET_METHOD(_message, message);
}

InternetTextMessage *HTTPResponse::message()
{
    return _message;
}

const char *HTTPResponse::className()
{
    return "HTTPResponse";
}

} // NET
