//
// InternetTextMessage.h
//

#pragma once

#include "net/InternetTextMessageHeader.h"
#include "net/InternetTextMessageBody.h"

namespace NET
{

class InternetTextMessage : public Raym::Object
{
private:
    InternetTextMessageHeader * _header;
    InternetTextMessageBody *   _body;

protected:
    InternetTextMessage();
    ~InternetTextMessage();

public:
    static InternetTextMessage *alloc();
    InternetTextMessage *initWithContentsOfFile(const char *path);
    InternetTextMessage *initWithData(Raym::Data *data);
    InternetTextMessage *initWithHeaderAndBody(InternetTextMessageHeader *header, InternetTextMessageBody *body);
    InternetTextMessage *retain();
    InternetTextMessage *autorelease();

    InternetTextMessageHeader *header();
    InternetTextMessageBody *body();

    Raym::Data *data();

    virtual const char *className();
};

} // NET

