﻿//
//
//

#pragma once

#include "Raym/Raym.h"
#include "ry0/iPTd/FFmpeg.h"

namespace ry0
{
namespace iPTd
{

class HTTPLiveStreaming : public FFmpeg
{
private:
    Raym::String *      _source;
    Raym::String *      _output_path;
    Raym::String *      _index_name;
    Raym::String *      _base_url;
    int                         _counter;

protected:
    HTTPLiveStreaming();
    ~HTTPLiveStreaming();

    virtual bool readLine(Raym::String *line);

public:
    void run();

public:
    static HTTPLiveStreaming *alloc();
    HTTPLiveStreaming *init();
    HTTPLiveStreaming *retain();
    HTTPLiveStreaming *autorelease();

    void setSource(Raym::String *source);
    void setOutputPath(Raym::String *output_path);
    Raym::String *outputPath();
    void setIndexName(Raym::String *index_name);

    bool start();

    Raym::String *indexPath();

    virtual const char *className();
};

} // iPTd
} // ry0
