namespace Editor.DefaultParser
{
    public class Sentence : ILexical
    {
        internal static Sentence Parse(string text, int index)
        {
            Expression exp = Expression.Parse(text.Substring(0,index));
            
            var sentence = new Sentence();
            sentence._expression = exp;
            sentence._before = new TextToken(text.Substring(0, index - exp.Length));
            sentence._after = new TextToken(text.Substring(index));

            return sentence;
        }

        private TextToken _before;
        private Expression _expression;
        private TextToken _after;

        internal TextToken Before { get { return _before; } }
        internal Expression Expression
        {
            get { return _expression; }
        }

        internal ILexical ExpressionLastToken
        {
            get { return _expression[_expression.Count- 1]; }
        }

        #region ILexical o

        public int Length
        {
            get { return _before.Length + _expression.Length + _after.Length; }
        }

        public string Text
        {
            get { return _before.Text + _expression.Text + _after.Text; }
        }

        #endregion
    }
}