﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace Editor
{
    public class HelpContent
    {
        string _oldVersionHelp = "";
        XmlHelpCache _helpCache;
        MethodBase _methodBase;
        Type _returnType;
        internal HelpContent(MethodBase methodBase, Type returnType, XmlHelpCache cache)
        {
            _methodBase = methodBase;
            _returnType = returnType;
            _helpCache = cache;
        }

        internal HelpContent(MethodInfo methodInfo, XmlHelpCache cache)
        {
            _helpCache = cache;
            _methodBase = methodInfo;
            _returnType = methodInfo.ReturnType;
        }
        internal HelpContent(string help)
        {
            _oldVersionHelp = help;
        }
        public string MethodDefine
        {
            get
            {
                if (_oldVersionHelp != "")
                {
                    return "";
                }
                StringBuilder str = new StringBuilder();
                str.Append(TypeNameService.ToSimpleTypeName(_returnType));
                str.Append(" ");
                if (_methodBase.IsConstructor)
                {
                    string name = TypeNameService.ToSimpleTypeName(_methodBase.DeclaringType);
                    str.Append(name);
                }
                else
                {
                    str.Append(_methodBase.Name);
                }
                str.Append("(");
                var parameters = _methodBase.GetParameters();
                for (int i = 0; i < parameters.Length; i++)
                {
                    if (i != 0)
                    {
                        str.Append(",");
                    }
                    str.Append(TypeNameService.ToSimpleTypeName(parameters[i].ParameterType));
                    str.Append(" ");
                    str.Append(parameters[i].Name);
                }
                str.Append(")");
                return str.ToString();
            }
        }
        public string Help
        {
            get {
                if (_oldVersionHelp != "") { return _oldVersionHelp; }
                return _helpCache.GetHelp(_methodBase);
            }
        }
        public override string ToString()
        {
            return MethodDefine + "\r\n" + Help;
        }
    }
}
