﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Editor.Parser.IronPythonParser
{
    class PyExpressionFactory
    {
        internal static IPyExpression AttributeRef(IPyExpression exp1, IPyExpression exp2)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp != null)
            {
                if (exp.Type == ExpressionType.Aggregate)
                {
                    exp.Child.Add(exp2);
                    return exp;
                }
            }
            return new PyExpression(ExpressionType.Aggregate, exp1, exp2);
        }
        internal static IPyExpression BitAnd(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.BitAnd, exp1, exp2);
        }
        internal static IPyExpression BitXOR(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.BitXOR, exp1, exp2);
        }
        internal static IPyExpression BitOR(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.BitOR, exp1, exp2);
        }
        internal static IPyExpression Comparison(IPyExpression ope, IPyExpression exp1, IPyExpression exp2)
        {
            IPyToken token = ope as IPyToken;
            if (token != null)
            {
                switch (token.Type)
                {
                    case TokenType.notEqual2:
                        return new PyExpression(ExpressionType.NotEqual, exp1, exp2);
                    case TokenType.graterEqual:
                        return new PyExpression(ExpressionType.GraterEqual, exp1, exp2);
                    case TokenType.lessEqual:
                        return new PyExpression(ExpressionType.LessEqual, exp1, exp2);
                    case TokenType.equal2:
                        return new PyExpression(ExpressionType.Equal, exp1, exp2);
                    case TokenType.notEqual:
                        return new PyExpression(ExpressionType.NotEqual, exp1, exp2);
                    case TokenType.lessThan:
                        return new PyExpression(ExpressionType.LessThan, exp1, exp2);
                    case TokenType.graterThan:
                        return new PyExpression(ExpressionType.GraterThan, exp1, exp2);
                    case TokenType.reserved_in:
                        return new PyExpression(ExpressionType.In, exp1, exp2);
                    case TokenType.reserved_is:
                        return new PyExpression(ExpressionType.Is, exp1, exp2);
                    case TokenType.Composition_IsNot:
                        return new PyExpression(ExpressionType.IsNot, exp1, exp2);
                    case TokenType.Composition_NotIn:
                        return new PyExpression(ExpressionType.NotIn, exp1, exp2);
                    default:
                        break;
                }
            }
            throw new NotSupportedException();
        }
        internal static IPyExpression NotTest(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.NotTest, exp, null);
        }
        internal static IPyExpression OrTest(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.OrTest, exp1, exp2);
        }
        internal static IPyExpression AndTest(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.AndTest, exp1, exp2);
        }
        internal static IPyExpression Lambda(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.Lambda, exp, null);
        }
        internal static IPyExpression Lambda(IPyExpression exp, IPyExpression param)
        {
            return new PyExpression(ExpressionType.Lambda, exp, param);
        }
        internal static IPyExpression ParameterList(IPyExpression exp1)
        {
            return ParameterList(exp1, null, null);
        }
        internal static IPyExpression ParameterList(IPyExpression exp1, IPyExpression exp2)
        {
            return ParameterList(exp1, exp2, null);
        }
        internal static IPyExpression ParameterList(IPyExpression exp1, IPyExpression exp2, IPyExpression exp3)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null || exp.Type != ExpressionType.ParameterList)
            {
                exp = new PyExpression(ExpressionType.ParameterList, exp1);
            }
            if (exp2 != null)
            {
                exp.Child.Add(exp2);
            }
            if (exp3 != null)
            {
                exp.Child.Add(exp3);
            }
            return exp;
        }
        internal static IPyExpression ParamAster(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.ParamAster, exp);
        }
        internal static IPyExpression ParamAster2(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.ParamAster2, exp);
        }
        internal static IPyExpression ParamEqual(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.ParamEqual, exp1, exp2);
        }
        internal static IPyExpression SubList(IPyExpression exp1, IPyExpression exp2)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp==null || exp.Type != ExpressionType.SubList)
            {
                exp = new PyExpression(ExpressionType.SubList, exp1);
            }
            exp.Child.Add(exp2);
            return exp;
        }
        internal static IPyExpression Trinomial(IPyExpression comparison, IPyExpression exp1, IPyExpression exp2)
        {
            var exp = new PyExpression(ExpressionType.Trinomial);
            exp.Child.Add(comparison);
            exp.Child.Add(exp1);
            exp.Child.Add(exp2);
            return exp;
        }
        internal static IPyExpression ExpressionList(IPyExpression exp1, IPyExpression exp2)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null || exp.Type != ExpressionType.ExpressionList)
            {
                exp = new PyExpression(ExpressionType.ExpressionList, exp1);
            }
            exp.Child.Add(exp2);
            return exp;
        }
        internal static IPyExpression Empty()
        {
            return new PyExpression(ExpressionType.Empty);
        }
        internal static IPyExpression ParenthForm(IPyExpression exp1)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null)
            {
                return exp1;
            }
            else if (exp.Type == ExpressionType.ExpressionList)
            {
                PyExpression expTmp = new PyExpression(ExpressionType.ParenthForm);
                expTmp.Child.AddRange(exp.Child);
                exp = expTmp;
            }
            else
            {
                exp = exp1 as PyExpression;
            }
            return exp;
        }
        internal static IPyExpression List(IPyExpression exp1)
        {
            return List(exp1, null);
        }
        internal static IPyExpression List(IPyExpression exp1, IPyExpression listfor)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp1 == null)
            {
                exp = new PyExpression(ExpressionType.List, new PyExpression(ExpressionType.Empty));
            }
            else 
            {
                exp = new PyExpression(ExpressionType.List, exp1);
            }
            if (listfor != null)
            {
                exp.Child.Add(listfor);
            }
            return exp;
        }
        internal static IPyExpression ListFor(IPyExpression targetList, IPyExpression testList)
        {
            return ListFor(targetList, testList, null);
        }
        internal static IPyExpression ListFor(IPyExpression targetList, IPyExpression testList, IPyExpression listIter)
        {
            PyExpression exp = new PyExpression(ExpressionType.ListFor, targetList, testList);
            if (listIter != null)
            {
                exp.Child.Add(listIter);
            }
            return exp;
        }
        internal static IPyExpression ListIf(IPyExpression test)
        {
            return ListIf(test, null);
        }
        internal static IPyExpression ListIf(IPyExpression test, IPyExpression listIter)
        {
            PyExpression exp = new PyExpression(ExpressionType.ListIf, test, listIter);
            return exp;
        }

        internal static IPyExpression Generator(IPyExpression exp1)
        {
            return Generator(exp1, null);
        }
        internal static IPyExpression Generator(IPyExpression exp1, IPyExpression generatorfor)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null)
            {
                exp = new PyExpression(ExpressionType.Generator, exp1);
            }
            else if (exp.Type == ExpressionType.ExpressionList)
            {
                PyExpression expTmp = new PyExpression(ExpressionType.Generator);
                expTmp.Child.AddRange(exp.Child);
                exp = expTmp;
            }
            else
            {
                exp = new PyExpression(ExpressionType.Generator, exp1);
            }
            if (generatorfor != null)
            {
                exp.Child.Add(generatorfor);
            }
            return exp;
        }
        internal static IPyExpression GeneratorFor(IPyExpression targetList, IPyExpression testList)
        {
            return GeneratorFor(targetList, testList, null);
        }
        internal static IPyExpression GeneratorFor(IPyExpression targetList, IPyExpression testList, IPyExpression generatorIter)
        {
            PyExpression exp = new PyExpression(ExpressionType.ListFor, targetList, testList);
            if (generatorIter != null)
            {
                exp.Child.Add(generatorIter);
            }
            return exp;
        }
        internal static IPyExpression GeneratorIf(IPyExpression test)
        {
            return GeneratorIf(test, null);
        }
        internal static IPyExpression GeneratorIf(IPyExpression test, IPyExpression generatorIter)
        {
            PyExpression exp = new PyExpression(ExpressionType.GeneratorIf, test, generatorIter);
            return exp;
        }
        internal static IPyExpression Dictionary(IPyExpression exp1, IPyExpression exp2)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null || exp.Type != ExpressionType.Dictionary)
            {
                exp = new PyExpression(ExpressionType.Dictionary, exp1);
            }
            if (exp2 != null)
            {
                exp.Child.Add(exp2);
            }
            return exp;
        }
        internal static IPyExpression KeyDatum(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.KeyDatum, exp1, exp2);
        }
        internal static IPyExpression StringConversion(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.StringConversion, exp);
        }
        internal static IPyExpression Subscription(IPyExpression exp1, IPyExpression exp2)
        {
            return new PyExpression(ExpressionType.Subscription, exp1, exp2);
        }
        internal static IPyExpression Slicing(IPyExpression primary, IPyExpression sliceItem)
        {
            PyExpression exp = new PyExpression(ExpressionType.Slicing, primary);
            PyExpression item2 = sliceItem as PyExpression;
            if (item2 == null || item2.Type != ExpressionType.SliceItemList)
            {
                if (sliceItem != null)
                {
                    exp.Child.Add(sliceItem);
                }
            }
            else
            {
                foreach (var item in item2.Child)
                {
                    exp.Child.Add(item);
                }
            }
            return exp;
        }
        internal static IPyExpression SliceItemList(IPyExpression list, IPyExpression sliceItem)
        {
            PyExpression exp = list as PyExpression;
            if (exp == null || exp.Type != ExpressionType.SliceItemList)
            {
                exp = new PyExpression(ExpressionType.SliceItemList, list);
            }
            if (sliceItem != null)
            {
                exp.Child.Add(sliceItem);
            }
            return exp;
        }
        internal static IPyExpression SliceItem(IPyExpression exp1, IPyExpression exp2)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null || exp.Type != ExpressionType.SliceItem)
            {
                return new PyExpression(ExpressionType.SliceItem, exp1, exp2);
            }
            if (exp2 != null)
            {
                exp.Child.Add(exp2);
            }
            return exp;
        }
        internal static IPyExpression SliceItem(IPyExpression exp1, IPyExpression exp2, IPyExpression exp3)
        {
            return new PyExpression(ExpressionType.SliceItem, exp1, exp2, exp3);
        }
        internal static IPyExpression TargetList(IPyExpression exp1, IPyExpression exp2)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null || exp.Type != ExpressionType.TargetList)
            {
                exp =  new PyExpression(ExpressionType.TargetList, exp1);
            }
            if (exp2 != null)
            {
                exp.Child.Add(exp2);
            }
            return exp;
        }
        internal static IPyExpression Call(IPyExpression primary)
        {
            return Call(primary, null);
        }
        internal static IPyExpression Call(IPyExpression primary, IPyExpression args)
        {
            return new PyExpression(ExpressionType.Call, primary, args);
        }
        internal static IPyExpression Call(IPyExpression primary, IPyExpression args, IPyExpression generatorFor)
        {
            return new PyExpression(ExpressionType.Call, primary, args, generatorFor);
        }
        internal static IPyExpression CallArguments(IPyExpression exp1, IPyExpression exp2)
        {
            return CallArguments(exp1, exp2, null, null);
        }
        internal static IPyExpression CallArguments(IPyExpression exp1, IPyExpression exp2, IPyExpression exp3)
        {
            return CallArguments(exp1, exp2, exp3, null);
        }
        internal static IPyExpression CallArguments(IPyExpression exp1, IPyExpression exp2, IPyExpression exp3, IPyExpression exp4)
        {
            PyExpression exp = exp1 as PyExpression;
            if (exp == null || exp.Type != ExpressionType.CallArguments)
            {
                exp = new PyExpression(ExpressionType.CallArguments, exp1);
            }
            PyExpression expTmp = exp2 as PyExpression;
            if (expTmp == null || expTmp.Type != ExpressionType.CallArguments)
            {
                if (exp2 != null)
                {
                    exp.Child.Add(exp2);
                }
            }
            else
            {
                foreach (var item in expTmp.Child)
                {
                    exp.Child.Add(item);
                }
            }

            expTmp = exp3 as PyExpression;
            if (expTmp == null || expTmp.Type != ExpressionType.CallArguments)
            {
                if (exp3 != null)
                {
                    exp.Child.Add(exp3);
                }
            }
            else
            {
                foreach (var item in expTmp.Child)
                {
                    exp.Child.Add(item);
                }
            }

            expTmp = exp4 as PyExpression;
            if (expTmp == null || expTmp.Type != ExpressionType.CallArguments)
            {
                if (exp4 != null)
                {
                    exp.Child.Add(exp4);
                }
            }
            else
            {
                foreach (var item in expTmp.Child)
                {
                    exp.Child.Add(item);
                }
            }
            return exp;
        }

        internal static IPyExpression KeywordItem(IPyExpression key, IPyExpression word)
        {
            return new PyExpression(ExpressionType.KeywordItem, key, word);
        }
        internal static IPyExpression KeywordArguments(IPyExpression args, IPyExpression keyword)
        {
            PyExpression exp = args as PyExpression;
            if (exp == null || exp.Type != ExpressionType.KeywordArguments)
            {
                exp = new PyExpression(ExpressionType.KeywordArguments, args);
            }
            if (keyword != null)
            {
                exp.Child.Add(keyword);
            }
            return exp;
        }
        internal static IPyExpression AsterArg(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.AsterArg, exp);
        }
        internal static IPyExpression AsterArg2(IPyExpression exp)
        {
            return new PyExpression(ExpressionType.AsterArg2, exp);
        }

    }
}
