﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace Editor.Parser.IronPythonParser
{
    public class PyTypeInfo
    {
        readonly Type _dotNetType;
        readonly string _exampleText;
        readonly KindOfType _kindOfType;
        readonly MemberInfo _memberInfo;
        public PyTypeInfo(Type dotNetType, string exampleText)
            : this(dotNetType, exampleText, KindOfType.Unknown, null)
        {
        }
        public PyTypeInfo(Type dotNetType, string exampleText, KindOfType kindOfType)
            :this(dotNetType, exampleText, kindOfType, null)
        {
        }
        public PyTypeInfo(Type dotNetType, string exampleText, KindOfType kindOfType, MemberInfo memberInfo)
        {
            _dotNetType = dotNetType;
            _exampleText = exampleText;
            _kindOfType = kindOfType;
            _memberInfo = memberInfo;
        }
        internal Type DotNetType
        {
            get { return _dotNetType; }
        }
        internal string ExampleText
        {
            get { return _exampleText; }
        }
        internal KindOfType KindOfType
        {
            get { return _kindOfType; }
        }
        internal MemberInfo MemberInfo
        {
            get { return _memberInfo; }
        }
        public override string ToString()
        {
            string typeString = _kindOfType.ToString();
            string dotNetTypeString = _dotNetType != null ? _dotNetType.FullName : "null";
            return "PyTypeInfo{" + typeString + ", " + dotNetTypeString + ", \"" + _exampleText + ", " + MemberInfo +"\"}";
        }
    }
    public enum KindOfType
    {
        DotNetNamaSpace,
        DotNetClass,
        DotNetMethod,
        DotNetVariable,
        DotNetEvent,
        PythonNameSpace,
        PythonClass,
        PythonMethod,
        PythonVariable,
        Unknown,
    }
}
