﻿using System;

namespace Editor.Parser.IronPythonParser
{
    public class TokenTransrater : yyParser.yyInput
    {
        PyTokenCollection _tokens;
        private int Position = -1;

        public TokenTransrater(string str)
        {
            PyLexer lexer = new PyLexer();
            _tokens = lexer.Lex(str);
            _tokens = _tokens.CreateWithoutWhiteSpace();
        }

        // 次のトークンに進む
        // 進めたら true を返す
        public bool advance()
        {
            if (_tokens.Count <= this.Position + 1)
            {
                return false;
            }
            else
            {
                this.Position++;
                return true;
            }
        }

        // 現在のトークンの種類を返す
        public int token()
        {
            switch (_tokens[Position].Type)
            {
                case TokenType.whiteSpece:
                    break;
                case TokenType.identifier:
                    return Token.Identifier;
                case TokenType.floatnumber1:
                    return Token.Number;
                case TokenType.floatnumber2:
                    return Token.Number;
                case TokenType.floatnumber3:
                    return Token.Number;
                case TokenType.octinteger:
                    return Token.Number;
                case TokenType.hexinteger:
                    return Token.Number;
                case TokenType.integer:
                    return Token.Number;
                case TokenType.longstring1:
                    return Token.stringliteral;
                case TokenType.longstring2:
                    return Token.stringliteral;
                case TokenType.longstring3:
                    return Token.stringliteral;
                case TokenType.longstring4:
                    return Token.stringliteral;
                case TokenType.longstring5:
                    return Token.stringliteral;
                case TokenType.longstring6:
                    return Token.stringliteral;
                case TokenType.powerEqual:
                    return Token.powerEqual;
                case TokenType.rightShiftEqual:
                    return Token.rightShiftEqual;
                case TokenType.leftShiftEqual:
                    return Token.leftShiftEqual;
                case TokenType.dot3:
                    return Token.dot3;
                case TokenType.power:
                    return Token.asterisk2;
                case TokenType.slash2:
                    return Token.slash2;
                case TokenType.leftShift:
                    return Token.leftShift;
                case TokenType.rightShift:
                    return Token.rightShift;
                case TokenType.notEqual2:
                    return Token.notEqual2;
                case TokenType.graterEqual:
                    return Token.graterEqual;
                case TokenType.lessEqual:
                    return Token.lessEqual;
                case TokenType.equal2:
                    return Token.equal2;
                case TokenType.notEqual:
                    return Token.notEqual;
                case TokenType.plusEqual:
                    return Token.plusEqual;
                case TokenType.minusEqual:
                    return Token.minusEqual;
                case TokenType.asteriskEqua:
                    return Token.asteriskEqua;
                case TokenType.slashEqual:
                    return Token.slashEqual;
                case TokenType.percentEqual:
                    return Token.percentEqual;
                case TokenType.ampersandEqual:
                    return Token.ampersandEqual;
                case TokenType.caretEqual:
                    return Token.caretEqual;
                case TokenType.verticalBarEqual:
                    return Token.verticalBarEqual;
                case TokenType.shortstring1:
                    return Token.stringliteral;
                case TokenType.shortstring2:
                    return Token.stringliteral;
                case TokenType.shortstring3:
                    return Token.stringliteral;
                case TokenType.shortstring4:
                    return Token.stringliteral;
                case TokenType.parenOpen:
                    return Token.parenOpen;
                case TokenType.parenClose:
                    return Token.parenClose;
                case TokenType.braceOpen:
                    return Token.braceOpen;
                case TokenType.braceClose:
                    return Token.braceClose;
                case TokenType.bracketOpen:
                    return Token.bracketOpen;
                case TokenType.bracketClose:
                    return Token.bracketClose;
                case TokenType.comma:
                    return Token.comma;
                case TokenType.backApostrophe:
                    return Token.backApostrophe;
                case TokenType.colon:
                    return Token.colon;
                case TokenType.dot:
                    return Token.dot;
                case TokenType.asterisk:
                    return Token.asterisk;
                case TokenType.equal:
                    return Token.equal;
                case TokenType.dash:
                    return Token.dash;
                case TokenType.plus:
                    return Token.plus;
                case TokenType.tilde:
                    return Token.tilde;
                case TokenType.slash:
                    return Token.slash;
                case TokenType.percent:
                    return Token.percent;
                case TokenType.ampersand:
                    return Token.ampersand;
                case TokenType.caret:
                    return Token.caret;
                case TokenType.verticalBar:
                    return Token.verticalBar;
                case TokenType.lessThan:
                    return Token.lessThan;
                case TokenType.graterThan:
                    return Token.graterThan;
                case TokenType.atSign:
                    return Token.atSign;
                case TokenType.reserved_and:
                    return Token.reserved_and;
                case TokenType.reserved_as:
                    return Token.reserved_as;
                case TokenType.reserved_assert:
                    return Token.reserved_assert;
                case TokenType.reserved_break:
                    return Token.reserved_break;
                case TokenType.reserved_class:
                    return Token.reserved_class;
                case TokenType.reserved_continue:
                    return Token.reserved_continue;
                case TokenType.reserved_def:
                    return Token.reserved_def;
                case TokenType.reserved_del:
                    return Token.reserved_del;
                case TokenType.reserved_elif:
                    return Token.reserved_elif;
                case TokenType.reserved_else:
                    return Token.reserved_else;
                case TokenType.reserved_except:
                    return Token.reserved_except;
                case TokenType.reserved_exec:
                    return Token.reserved_exec;
                case TokenType.reserved_finally:
                    return Token.reserved_finally;
                case TokenType.reserved_for:
                    return Token.reserved_for;
                case TokenType.reserved_from:
                    return Token.reserved_from;
                case TokenType.reserved_global:
                    return Token.reserved_global;
                case TokenType.reserved_if:
                    return Token.reserved_if;
                case TokenType.reserved_import:
                    return Token.reserved_import;
                case TokenType.reserved_in:
                    return Token.reserved_in;
                case TokenType.reserved_is:
                    return Token.reserved_is;
                case TokenType.reserved_lambda:
                    return Token.reserved_lambda;
                case TokenType.reserved_not:
                    return Token.reserved_not;
                case TokenType.reserved_or:
                    return Token.reserved_or;
                case TokenType.reserved_pass:
                    return Token.reserved_pass;
                case TokenType.reserved_print:
                    return Token.reserved_print;
                case TokenType.reserved_raise:
                    return Token.reserved_raise;
                case TokenType.reserved_return:
                    return Token.reserved_return;
                case TokenType.reserved_try:
                    return Token.reserved_try;
                case TokenType.reserved_while:
                    return Token.reserved_while;
                case TokenType.reserved_with:
                    return Token.reserved_with;
                case TokenType.reserved_yield:
                    return Token.reserved_yield;
                default:
                    break;
            }
            return _tokens[Position].Text[0];
        }

        // 現在のトークンの値を返す
        public object value()
        {
            PyToken token = _tokens[Position];
            return token;
        }
    }
}
