﻿using NUnit.Framework;
using Editor;
using NUnit.Framework.SyntaxHelpers;

namespace EditorTest
{
    [TestFixture]
    public class CommandListHistoryTest
    {
        CommandListHistory _history;
        [SetUp]
        public void SetUp()
        {
            _history = new CommandListHistory();
        }

        [Test]
        public void Test()
        {
            _history.Add("A");
            _history.Add("B");

            CommandListHistoryIterator ite = _history.GetEndIterator();
            Assert.That(ite.GetValue(), Is.EqualTo("B"));
            ite.Decrement();
            Assert.That(ite.GetValue(), Is.EqualTo("A"));
            Assert.That(ite.IsBegin(), Is.True);
            ite.Decrement();
            Assert.That(ite.GetValue(), Is.EqualTo("A"));
            Assert.That(ite.IsBegin(), Is.True);
        }
    }
}
