﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Editor
{
    public partial class Help : Form, IHelpWindow
    {
        SizeF _lastSize = new SizeF(0, 0);
        private Point _basePoint = new Point(0, 0);
        HelpContentCollection _helps = new HelpContentCollection();

        public Help()
        {
            InitializeComponent();
        }

        private void Help_Paint(object sender, PaintEventArgs e)
        {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < _helps.Count; i++)
            {
                var help = _helps[i];
                if (i != 0)
                {
                    str.Append("\r\n");
                }
                str.Append(help.MethodDefine);
                str.Append("\r\n");
                str.Append(help.Help);
            }
            string _text = str.ToString();
            DrawString(e, _text);
        }

        private void DrawString(PaintEventArgs e, string _text)
        {
            if (_text == "")
            {
                _lastSize = new SizeF(0, 0);
                Opacity = 0;
                return;
            }
            Font font = new Font("MS UI Gothic", 9, FontStyle.Regular);
            SizeF size = e.Graphics.MeasureString(_text, font);
            if (size != _lastSize)
            {
                this.Width = (int)size.Width + 1;
                this.Height = (int)size.Height + 1;
                Top = _basePoint.Y - Height - 3;
                _lastSize = size;
            }
            e.Graphics.DrawString(_text, font, Brushes.Black, 0, 0);
        }


        #region IHelpWindow メンバ

        void IHelpWindow.SetText(HelpContentCollection helps)
        {
            _helps = helps;
            
            Invalidate();
        }

        void IHelpWindow.SetVisible(bool isVisible)
        {
            if (isVisible == true)
            {
                Opacity = 1;
            }
            else
            {
                Opacity = 0;
            }
        }

        void IHelpWindow.SetLocation(Point location)
        {
            _basePoint = location;
            Left = _basePoint.X;
            Top = _basePoint.Y - Height - 3;
        }

        #endregion
    }
}
