﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace Editor
{
    public partial class Intelisence : Form, IIntelisenceWindow
    {
        public Intelisence()
        {
            InitializeComponent();
        }

        #region IIntelisenceWindow メンバ

        void IIntelisenceWindow.ChangeStatus(IntelisenceStatus status)
        {
            this.Location = status.Location;
            if (status.Visible)
            {
                this.Opacity = 100;
            }
            else
            {
                this.Opacity = 0;
            }
            if (status.IsAutoSelect)
            {
                listBox1.SelectedIndex = status.SelectedIndex;
                listBox1.TopIndex = status.SelectedIndex >= 5 ? status.SelectedIndex - 5 : 0;
            }
            else
            {
                listBox1.SelectedIndex = status.SelectedIndex;
            }

            if (status.IsSelected == false)
            {
                listBox1.SelectedIndices.Clear();
            }
        }

        void IIntelisenceWindow.ChangeList(string[] list)
        {
            listBox1.BeginUpdate();
            listBox1.Items.Clear();
            foreach (var item in list)
            {
                listBox1.Items.Add(item);
            }
            listBox1.EndUpdate();
        }

        #endregion
    }
}
