﻿using System;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using IronPythonIntelisence;

namespace Editor
{
    public partial class PythonTextBox : CustomTextBox, ITextOutout
    {
        public PythonTextBox()
        {
            InitializeComponent();
        }
        Form _ownerForm;
        Help help;
        Intelisence intelisence;
        private void PythonTextBox_ParentChanged(object sender, EventArgs e)
        {
            if (_ownerForm != null)
            {
                _ownerForm.LocationChanged -= new EventHandler(ownerForm_LocationChanged);
            }

            _ownerForm = this.GetOwner();
            _ownerForm.LocationChanged += new EventHandler(ownerForm_LocationChanged);

            if (help == null)
            {
                help = new Help();
            }
            if (intelisence == null)
            {
                intelisence = new Intelisence();
            }
            intelisence.Owner = _ownerForm;
            intelisence.Show();
            help.Owner = _ownerForm;
            help.Show();

            IronPythonTextBoxBuilder builder = new IronPythonTextBoxBuilder();
            builder.HelpWindow = help;
            builder.IntelisenceWindow = intelisence;
            builder.TextOutput = this;
            builder.PytohnTextBox = this;
            builder.Bind();
        }

        void ownerForm_LocationChanged(object sender, EventArgs e)
        {
            OnLocationChangedAndWindowLocationChanged();
        }

        private Form GetOwner()
        {
            return SearchOwner(this);
        }
        private Form SearchOwner(Control cont)
        {
            if (cont is Form)
            {
                return cont as Form;
            }
            if (cont.Parent == null)
            {
                return null;
            }
            var owner = SearchOwner(cont.Parent);
            return owner;
        }

        #region ITextOutout メンバ

        public void OutputText(string text)
        {
            if (TextOutput != null)
            {
                TextOutput(this, new TextEventArgs(text));
            }
        }

        #endregion

        public event EventHandler<TextEventArgs> TextOutput;
    }
}
