<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:include href="main.xsl" />


<!--
要素名: document
説　明: main.xslのオーバーロード
-->
<xsl:template match="/document">
    <p><xsl:text>サポートBBSの「ディストロ別インストール情報」スレに投稿された書き込みなどを転載しています。</xsl:text></p>
    <p><xsl:text>尚、ここに書かれている事は記載された時点での情報です。</xsl:text><br />
    <xsl:text>JDまたはディストリビュータ側の変更により内容が異なる場合があります。</xsl:text><br />
    <xsl:text>特に仕様が変わってVer.1.98以降は openssl の代わりに gnutls を使用するようになったので注意してください 。</xsl:text></p>
    <ul class="disc">
        <xsl:apply-templates select="dist" mode="link" />
    </ul>
    <xsl:apply-templates />
</xsl:template>


<!--
要素名: dist
説　明: ディストリごとの枠( main.xslの <block> に近い )
-->
<xsl:template match="dist" mode="link">
    <li>
        <a href="#{generate-id()}"><xsl:value-of select="@name" /></a>
    </li>
</xsl:template>

<xsl:template match="dist">
    <div class="border">
        <h3 class="blue"><a name="{generate-id()}"><xsl:value-of select="@name" /></a></h3>
        <xsl:apply-templates />
    </div>
</xsl:template>


<!--
要素名: group
説　明: レスのグループ分け
-->
<xsl:template match="group">
    <div class="border"><xsl:apply-templates select="res" /></div>
</xsl:template>

<xsl:template match="other|res">
    <pre>
    <xsl:if test="name()='res'">
        <xsl:attribute name="class">res</xsl:attribute>
    </xsl:if>
    <xsl:value-of select="substring-after( ., '&#x0A;' )" />
    </pre>
</xsl:template>


</xsl:stylesheet>
