#include <iostream>

#include "hash.h"

ArticleHash::ArticleHash( const size_t tablesize )
    : m_size( 0 ),
      m_min_hash( tablesize + 1 )
{
    m_table.resize( tablesize );
    m_iterator = new ArticleHashIterator( this );
}


ArticleHash::~ArticleHash()
{
    const size_t tblsize = m_table.size();
    for( size_t hash = 0; hash < tblsize; ++hash ){
        std::cout << hash << " : size = " << m_table[ hash ].size() << std::endl;
    }

    delete m_iterator;
}


void ArticleHash::push( const size_t hash, ArticleBase* article )
{
    if( hash < m_min_hash ) m_min_hash = hash;
    ++m_size;
    m_table[ hash ].push_back( article );
}


ArticleBase* ArticleHash::find( const size_t hash, const std::string& id )
{
    std::vector< ArticleBase* >::iterator it = m_table[ hash ].begin();
    for( ; it != m_table[ hash ].end(); ++it ) if( *( *it ) == id ) return *it;

    return NULL;
}


const ArticleHashIterator ArticleHash::begin()
{
    m_it_hash = m_min_hash;
    m_it_pos = 0;
    m_it_size = 0;

    return *m_iterator;
}


ArticleBase* ArticleHash::it_get()
{
//    std::cout << "ArticleHash::it_get hash = " << m_it_hash << " pos = " << m_it_pos << std::endl;

    if( m_it_hash >= m_table.size() ) return NULL;

    return m_table[ m_it_hash ][ m_it_pos ];
}


void ArticleHash::it_inc()
{
//    std::cout << "ArticleHash::it_inc hash = " << m_it_hash << " pos = " << m_it_pos;

    ++m_it_size;
    if( m_it_size <= size() ){

        ++m_it_pos;
        if( m_it_pos == m_table[ m_it_hash ].size() ){

            m_it_pos = 0;
            while( ! m_table[ ++m_it_hash ].size() );
        }
    }

//    std::cout << " -> hash = " << m_it_hash << " pos = " << m_it_pos << " size = " << m_it_size << " / " << size() << std::endl;
}


/////////////////////////////////////////////////////


ArticleHashIterator::ArticleHashIterator( ArticleHash* hashtable )
    : m_hashtable( hashtable )
{}


ArticleBase* ArticleHashIterator::operator * ()
{
    return m_hashtable->it_get();
}


ArticleBase* ArticleHashIterator::operator ++ ()
{
    m_hashtable->it_inc();
    return m_hashtable->it_get();
}


bool ArticleHashIterator::operator != ( const size_t size )
{
    return ( m_hashtable->it_size() != size );
}


/////////////////////////////////////////////////////


enum
{
    HASH_TBLSIZE = 1000
};

int get_hash( const std::string& id )
{
    return atoi( id.c_str() ) % HASH_TBLSIZE;
}


int main()
{
    ArticleHash hashtable( HASH_TBLSIZE );
    ArticleBase* article;
    std::string id;

    ///////////////

    id = "11";
    article = new ArticleBase( id );
    hashtable.push( get_hash( id ), article );

    id = "11";
    std::cout << *( hashtable.find( get_hash( id ), id ) ) << std::endl;
    std::cout << "\n";

    ///////////////

    for( int i = 0; i < 10000; ++i ){

        char tmp[ 128 ];
        sprintf( tmp, "%d", rand() & 0xffff );
        id = tmp;
        article = new ArticleBase( id );
        hashtable.push( get_hash( id ), article );
//        std::cout << id << std::endl;
    }
    std::cout << "\n";

    ArticleHashIterator it = hashtable.begin();
    for( ; it != hashtable.end(); ++it ) std::cout << *( *it ) << std::endl;
    std::cout << "\n";

    return 0;
}
