/*

  ArticleBaseのチェーン式ハッシュテーブル

  コンパイルが遅くなるのでテンプレートを使用しないでArticleBase専用にした

*/

#include <vector>
#include <string>

typedef std::string ArticleBase;

class ArticleHashIterator;

class ArticleHash
{
    size_t m_size;
    size_t m_min_hash;
    ArticleHashIterator* m_iterator;
    std::vector< std::vector< ArticleBase* > > m_table;

    // iterator 用変数
    size_t m_it_hash;
    size_t m_it_pos;
    size_t m_it_size;

  public:

    ArticleHash( const size_t tablesize );
    ~ArticleHash();

    const size_t size() const { return m_size; }

    void push( const size_t hash, ArticleBase* article );

    ArticleBase* find( const size_t hash, const std::string& id );

    // iterator 用関数
    const ArticleHashIterator begin();
    const size_t end() const{ return size(); }
    ArticleBase* it_get();
    void it_inc();
    const size_t it_size() const { return m_it_size; }
};


///////////////////////////////////////////


class ArticleHashIterator
{
    ArticleHash* m_hashtable;

  public:

    ArticleHashIterator( ArticleHash* hashtable );

    ArticleBase* operator * ();
    ArticleBase* operator ++ ();
    bool operator != ( const size_t size );
};
