<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:include href="main.xsl" />


<!--xsl:template match="/document">
    <xsl:apply-templates>
        <xsl:sort select="@date" order="ascending" />
    </xsl:apply-templates>
</xsl:template-->


<!--
要素名: latest
説　明: 最新の要素<release>のみを表示する
-->
<xsl:template match="latest">
    <xsl:variable name="latest" select="document( concat( @year, '.xml' ) )/document/release[last()]" />

    <p class="age">
    <span class="number"><xsl:number format="1" /></span>
    <span class="underline">
        <xsl:text>バージョン</xsl:text></span><xsl:text>：</xsl:text><span class="nanashi"><xsl:value-of select="$latest/@version" />
        <xsl:if test="not( contains( $latest/@version, 'b' ) or contains( $latest/@version, 'rc' ) )"><xsl:text> ★</xsl:text></xsl:if>
    </span>
    <span class="red"><xsl:text> [new]</xsl:text></span>
    <xsl:text>：</xsl:text><xsl:value-of select="$latest/@date" /><xsl:text> 00:00:00</xsl:text>
    </p>

    <pre class="history">
        <xsl:value-of select="substring-after( $latest, '&#x0A;' )" />
    </pre>
</xsl:template>


<!--
要素名: release
説　明: スレッド風に表示する
-->
<xsl:template match="release">
    <p class="sage">
    <span class="number"><xsl:number format="1" /></span>
    <span class="underline">
        <xsl:text>バージョン</xsl:text></span><xsl:text>：</xsl:text><span class="nanashi"><xsl:value-of select="@version" />
        <xsl:if test="not( contains( @version, 'b' ) or contains( @version, 'rc' ) )"><xsl:text> ★</xsl:text></xsl:if>
    </span>
    <xsl:text> [sage]：</xsl:text><xsl:value-of select="@date" /><xsl:text> 00:00:00</xsl:text>
    </p>

    <pre class="history">
        <xsl:value-of select="substring-after( ., '&#x0A;' )" />
    </pre>
</xsl:template>


</xsl:stylesheet>
