// レーベンシュタイン距離 ( GPL2 )

#include <string>
#include <vector>
#include <iostream>
#include <assert.h>
#include <glibmm.h>

const double leven( std::vector< std::vector< int > >& dist,
            const Glib::ustring& str1, const Glib::ustring& str2 )
{
    const size_t maxlng = dist.size() -1;
    const size_t lng1 = MIN( maxlng, str1.length() );
    const size_t lng2 = MIN( maxlng, str2.length() );
    const gunichar sp_wide = Glib::ustring( "　" )[0];

    std::cout << "str1 = " << str1.raw() << " lng1 = " << lng1 << std::endl
              << "str2 = " << str2.raw() << " lng2 = " << lng2 << std::endl
              << "maxlng = " << maxlng << std::endl;

    dist[ 0 ][ 0 ] = 0;
    for( size_t i = 1, cost = 0; i <= lng1; ++i ){

        const gunichar c = str1[ i-1 ];

        // 空白の挿入コストは0
        if( c != ' ' && c != sp_wide ) ++cost; 

        dist[ i ][ 0 ] = cost;
    }
    for( size_t i = 1, cost = 0; i <= lng2; ++i ){

        const gunichar c = str2[ i-1 ];

        // 空白の削除コストは0
        if( c != ' ' && c != sp_wide ) ++cost; 

        dist[ 0 ][ i ] = cost;
    }

    for( size_t i = 1; i <= lng1; ++i ){
        for( size_t j = 1; j <= lng2; ++j ){        

            const gunichar c1 = str1[ i-1 ];
            const gunichar c2 = str2[ j-1 ];

            int cost_replace = dist[ i-1 ][ j-1 ];
            if( c1 != c2 ) cost_replace += 1;

            int cost_insert = dist[ i-1 ][ j ];
            // 空白の挿入コストは0
            if( c1 != ' ' && c1 != sp_wide ) cost_insert += 1;

            int cost_delete = dist[ i ][ j-1 ];
            // 空白の削除コストは0
            if( c2 != ' ' && c2 != sp_wide ) cost_delete += 1;

            dist[ i ][ j ] = MIN( cost_replace, MIN( cost_insert, cost_delete ) );
        }
    }

    for( size_t i = 0; i <= lng1; ++i ){
        for( size_t j = 0; j <= lng2; ++j ) std::cout << dist[ i ][ j ] << " ";
        std::cout << std::endl;
    }

    // 0 - 1 の範囲に正規化
    return ( double )dist[ lng1 ][ lng2 ] / MAX( dist[ lng1 ][ 0 ], dist[ 0 ][ lng2 ] );
}




const size_t MAXSTR = 64;

int main( int argc, char* argv[] )
{
    assert( argc == 3 );

    std::vector< std::vector< int > > dist( MAXSTR, std::vector< int >( MAXSTR ) );

    const Glib::ustring str1( argv[1] );
    const Glib::ustring str2( argv[2] );

    const double ret = leven( dist, str1, str2 );

    std::cout << "distance = " << ret << std::endl;

    return 0;
}
