//
// FTS client library
// Copyright (C) 2001 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation; either version 2.1
// of the License, or (at your option) any later version.
// 
// See file COPYING.LIB for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

using System;
using System.IO;
using System.Diagnostics;

namespace ircam.fts.client
{
    public class FtsPipeConnection : FtsServerConnection
    {
        public FtsPipeConnection(FtsProcess fts)
        {
            streamReader = fts.StandardOutput;
            streamWriter = fts.StandardInput;
        }

        public override void Close()
        {
            streamWriter.Close();
            streamReader.Close();
        }

        // **********************************************************************
        // This is not implemented because of
        // .NET Framework doesn't support a binary stream of the process.
        // **********************************************************************
        public override int Read(byte[] b, int off, int len)
        {
            throw new NotImplementedException();
        }

        // **********************************************************************
        // This is not implemented because of
        // .NET Framework doesn't support a binary stream of the process.
        // **********************************************************************
        public override void Write(byte[] b, int off, int len)
        {
            throw new NotImplementedException();
        }

        private StreamReader streamReader;
        private StreamWriter streamWriter;
    }
}