//
// FTS client library
// Copyright (C) 2001 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation; either version 2.1
// of the License, or (at your option) any later version.
// 
// See file COPYING.LIB for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

using System;
using System.Runtime.InteropServices;

namespace ircam.fts.client
{
    /// <summary>
    /// IEEE-754 floating-point conversion.
    /// </summary>
    [StructLayoutAttribute(LayoutKind.Explicit)]
    public struct Union
    {
        [FieldOffsetAttribute(0)]
        public long l;
        [FieldOffsetAttribute(0)]
        public double d;

        public double LongBitsToDouble(long v)
        {
            this.l = v;
            return this.d;
        }

        public long DoubleToLongBits(double v)
        {
            if (Single.IsNaN((float)v))
            {
                this.l = 0x7ff80000;
                return this.l << 32;
            }

            this.d = v;
            return this.l;
        }

        public long DoubleToRawLongBits(double v)
        {
            this.d = v;
            return this.l;
        }
    }
}
