//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.jmax;
using ircam.jmax.dialogs;
using ircam.jmax.fts;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher
{
    //
    // A class representing a selection in Ermes, with its associated FtsSelection
    // object.
    // The Class implement all the operations availables on the selection.
    //

    //HACK: public class ErmesSelection : System.Windows.Forms.IDataObject
    public class ErmesSelection
    {
        public static ErmesSelection patcherSelection = new ErmesSelection();

        private MaxVector objects = new MaxVector();
        private MaxVector connections = new MaxVector();
        private ErmesSketchPad owner;

        internal FtsSelection ftsSelection;

        public static FtsSelection FtsSelection
        {
            get
            {
                return patcherSelection.ftsSelection;
            }
        }

        //UNDONE: Constructor 'java.awt.datatransfer.DataFlavor.DataFlavor' was not converted. 
        public static System.Windows.Forms.DataFormats patcherSelectionFlavor;
        //UNDONE: The initialization of  'flavors' was moved to static method 'ircam.jmax.editors.patcher.ErmesSelection'.
        public static System.Windows.Forms.DataFormats[] flavors;

        public object GetData(System.Windows.Forms.DataFormats flavor)
        {
            return ftsSelection;
        }

        //UNDONE: Constructor 'java.awt.datatransfer.DataFlavor.DataFlavor' was not converted. 
        //        public DataFlavor[] GetData(Type flavor)
        //        {
        //            return GetData((System.Windows.Forms.DataFormats) flavor);
        //        }

        public System.Windows.Forms.DataFormats[] GetFormats()
        {
            return flavors;
        }

        public bool isDataFlavorSupported(System.Windows.Forms.DataFormats flavor)
        {
            return flavor.Equals(patcherSelectionFlavor);
        }

        public ErmesSelection()
        {
            if (flavors == null)
                flavors = new System.Windows.Forms.DataFormats[1];

            flavors[0] = patcherSelectionFlavor;

            try
            {
                ftsSelection = new FtsSelection();
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[ErmesSelection]: Error in FtsSelection creation!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void select(IDisplayObject obj)
        {
            if (obj is GraphicConnection)
                select((GraphicConnection)obj);
            else
                select((GraphicObject)obj);
        }

        public void select(GraphicObject obj)
        {
            if (obj.SketchPad != owner)
                Owner = obj.SketchPad;

            if (!objects.Contains(obj))
            {
                objects.AddElement(obj);
                ftsSelection.Add(obj.FtsObject);
                obj.isSelected = true;
            }
        }

        public void select(GraphicConnection connection)
        {
            if (connection.SketchPad != owner)
                Owner = connection.SketchPad;

            if (!connections.Contains(connection))
            {
                connections.AddElement(connection);
                ftsSelection.Add(connection.FtsConnection);
                connection.Selected = true;
            }
        }

        public void add(IDisplayObject obj)
        {
            if (obj is GraphicConnection)
                add((GraphicConnection)obj);
            else
                add((GraphicObject)obj);
        }

        public void add(GraphicObject obj)
        {
            if (!objects.Contains(obj))
            {
                objects.AddElement(obj);
                ftsSelection.Add(obj.FtsObject);
            }
        }

        public void add(GraphicConnection connection)
        {
            if (!connections.Contains(connection))
            {
                connections.AddElement(connection);
                ftsSelection.Add(connection.FtsConnection);
            }
        }

        public void deselect(GraphicObject obj)
        {
            if (objects.Contains(obj))
            {
                obj.isSelected = false;
                objects.RemoveElement(obj);
                ftsSelection.Remove(obj.FtsObject);
            }
        }

        public void deselect(GraphicConnection connection)
        {
            if (connections.Contains(connection))
            {
                connection.Selected = false;
                connections.RemoveElement(connection);
                ftsSelection.Remove(connection.FtsConnection);
            }
        }

        public bool isSelected(GraphicObject obj)
        {
            return objects.Contains(obj);
        }


        public bool isSelected(GraphicConnection connection)
        {
            return connections.Contains(connection);
        }

        public bool isSingleton()
        {
            return objects.Size == 1;
        }

        public GraphicObject getSingleton()
        {
            return (GraphicObject)objects[0];
        }

        public System.Collections.IEnumerator SelectedObjects
        {
            get
            {
                return objects.Elements();
            }
        }

        public System.Collections.IEnumerator SelectedConnections
        {
            get
            {
                return connections.Elements();
            }
        }

        public int SelectedObjectsSize
        {
            get
            {
                return objects.Size;
            }
        }

        public void DeselectAll()
        {
            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                ((GraphicObject)e.Current).isSelected = false;
            }

            for (System.Collections.IEnumerator e = connections.Elements(); e.MoveNext(); )
            {
                ((GraphicConnection)e.Current).Selected = false;
            }

            objects.RemoveAllElements();
            connections.RemoveAllElements();
            ftsSelection.Clean();
        }

        public void redraw()
        {
            GraphicObject obj;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                obj = (GraphicObject)e.Current;
                obj.Redraw();
            }

            GraphicConnection connection;

            for (System.Collections.IEnumerator e = connections.Elements(); e.MoveNext(); )
            {
                connection = (GraphicConnection)e.Current;
                connection.redraw();
            }
        }

        public bool isEmpty
        {
            get
            {
                return objects.IsEmpty && connections.IsEmpty;
            }
        }

        public bool isObjectsEmpty
        {
            get
            {
                return objects.IsEmpty;
            }
        }

        public bool hasObjects
        {
            get
            {
                return (!objects.IsEmpty);
            }
        }

        public bool hasConnections
        {
            get
            {
                return (!connections.IsEmpty);
            }
        }

        public ErmesSketchPad Owner
        {
            get
            {
                return owner;
            }

            set
            {
                if ((value != null) && (this.owner != value))
                {
                    if (!isEmpty)
                    {
                        DeselectAll();
                        value.Redraw();
                    }
                }

                this.owner = value;
            }
        }

        public bool ownedBy(ErmesSketchPad owner)
        {
            return (this.owner == owner);
        }

        // Operations on selection

        public void deleteAll()
        {
            Owner.setUndo("Remove", true, false);

            if (connections.Size > 0)
            {
                for (System.Collections.IEnumerator e = connections.Elements(); e.MoveNext(); )
                {
                    ((GraphicConnection)e.Current).Delete();
                }

                connections.RemoveAllElements();
            }

            if (objects.Size > 0)
            {
                Owner.FtsPatcher.RequestDeleteObjects(objects.Elements());

                for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
                {
                    ((GraphicObject)e.Current).Delete();
                }

                objects.RemoveAllElements();
            }

            ftsSelection.Clean();

            if (owner != null)
                owner.DisplayList.ReassignLayers();
        }


        // Generic operation on objects in the selection

        public void apply(ProcessObject action)
        {
            object[] values = objects.ObjectArray;
            int size = objects.Size;

            for (int i = 0; i < size; i++)
            {
                GraphicObject obj = (GraphicObject)values[i];

                action(obj);
            }
        }

        //--------------------------------------------------------
        //    moveAll
        //    Move the selected elements
        //--------------------------------------------------------

        public void moveAllBy(int dx, int dy)
        {
            GraphicObject obj;

            object[] values = objects.ObjectArray;
            int size = objects.Size;

            for (int i = 0; i < size; i++)
            {
                obj = (GraphicObject)values[i];

                obj.Redraw();
                obj.redrawConnections();
                obj.moveBy(dx, dy);
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void resizeToMaxWidth()
        {
            Owner.setUndo("Resize", false, false);

            int max = 0;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                if (obj.Width > max)
                    max = obj.Width;
            }

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                obj.Redraw();
                obj.redrawConnections();
                obj.Width = max;
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void resizeToMaxHeight()
        {
            Owner.setUndo("Resize", false, false);

            int max = 0;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                if (obj.Height > max)
                    max = obj.Height;
            }

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                obj.Redraw();
                obj.redrawConnections();
                obj.Height = max;
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void resizeToMinWidth()
        {
            Owner.setUndo("Resize", false, false);

            int min = -1;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                if ((min == -1) || obj.Width < min)
                    min = obj.Width;
            }

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                obj.Redraw();
                obj.redrawConnections();
                obj.Width = min;
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void resizeToMinHeight()
        {
            Owner.setUndo("Resize", false, false);

            int min = -1;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                if ((min == -1) || obj.Height < min)
                    min = obj.Height;
            }

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                obj.Redraw();
                obj.redrawConnections();
                obj.Width = min;
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void alignTop()
        {
            Owner.setUndo("Align", false, false);

            int value_Renamed = minY();

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                obj.Redraw();
                obj.redrawConnections();
                obj.moveBy(0, value_Renamed - obj.Y);
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void alignBottom()
        {
            Owner.setUndo("Align", false, false);

            int value_Renamed = maxY();

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                obj.Redraw();
                obj.redrawConnections();
                obj.moveBy(0, value_Renamed - (obj.Y + obj.Height));
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void alignLeft()
        {
            Owner.setUndo("Align", false, false);

            int value_Renamed = minX();

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                obj.Redraw();
                obj.redrawConnections();
                obj.moveBy(value_Renamed - obj.X, 0);
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void alignRight()
        {
            Owner.setUndo("Align", false, false);

            int value_Renamed = maxX();

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                obj.Redraw();
                obj.redrawConnections();
                obj.moveBy(value_Renamed - (obj.X + obj.Width), 0);
                obj.Redraw();
                obj.redrawConnections();
            }
        }

        public void bringToFront()
        {
            if (hasObjects)
                owner.DisplayList.ObjectsToFront(objects.ObjectArray, objects.Size);
        }

        public void sendToBack()
        {
            if (hasObjects)
                owner.DisplayList.objectsToBack(objects.ObjectArray, objects.Size);
        }

        // Queries about selection geometry

        internal int minY()
        {
            int min = System.Int32.MaxValue;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                if (min >= obj.Y)
                    min = obj.Y;
            }

            return min;
        }

        internal int minX()
        {
            int min = System.Int32.MaxValue;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                if (min >= obj.X)
                    min = obj.X;
            }

            return min;
        }

        internal int maxY()
        {
            int max = 0;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;

                if (max < obj.Y + obj.Height)
                    max = obj.Y + obj.Height;
            }

            return max;
        }

        internal int maxX()
        {
            int max = 0;

            for (System.Collections.IEnumerator e = objects.Elements(); e.MoveNext(); )
            {
                GraphicObject obj = (GraphicObject)e.Current;
                if (max < obj.X + obj.Width)
                    max = obj.X + obj.Width;
            }

            return max;
        }

        // The bounds of the selection as a rectangle
        // Still miss the connections (but should be ok like this)

        internal System.Drawing.Rectangle bounds = new System.Drawing.Rectangle();

        internal System.Drawing.Rectangle Bounds
        {
            get
            {
                if (hasObjects)
                {
                    ((GraphicObject)objects[0]).getBounds(bounds);

                    for (int i = 1; i < objects.Size; i++)
                        ((GraphicObject)objects[i]).rectangleUnion(bounds);

                    return bounds;
                }
                else
                    return bounds = new System.Drawing.Rectangle(0, 0, 0, 0);
            }
        }
    }
}