using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using ircam.jmax.fts;
using ircam.jmax.dialogs;
using ircam.jmax.editors.console;
using ircam.jmax.editors.project;
using ircam.jmax.editors.configuration;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher
{
    public partial class ErmesSketchWindow : Form
	{
        private FtsPatcherObject itsPatcher;
        private ErmesSketchPad itsSketchPad;
        private const string helpfile = "MaxSharp.chm";

        public ErmesSketchWindow()
        {
            InitializeComponent();
        }

        public ErmesSketchWindow(FtsPatcherObject patcherObj)
		{
			InitializeComponent();

            itsPatcher = patcherObj;

            // Make the content
            itsSketchPad = new ErmesSketchPad(this, itsPatcher);

            // Make the title
            MakeTitle();
		}

        private void About()
        {
            AboutDialog ad = new AboutDialog();
            ad.ShowDialog(this);
            ad.Dispose();
        }

        public ircam.jmax.toolkit.IEditor IEditor
        {
            get
            {
                return itsSketchPad;
            }
        }

        public ErmesSketchPad SketchPad
        {
            get
            {
                return itsSketchPad;
            }
        }

        private void MakeTitle()
        {
            SetTitle(MaxWindowManager.WindowManager.MakeUniqueWindowTitle(GetTitle()));
        }

        public void SetTitle(string fileName)
        {
            string title;

            int id = fileName.LastIndexOf('/');

            if (id != -1)
                title = fileName.Substring(id + 1);
            else
                title = fileName;

            if (!Text.Equals(title))
            {
                base.Text = MaxWindowManager.WindowManager.MakeUniqueWindowTitle(title);
                MaxWindowManager.WindowManager.WindowChanged(this);
            }
        }

        internal string GetTitle()
        {
            string name;

            if (itsPatcher.IsARootPatcher)
            {
                name = itsPatcher.Name;
                if ((object)name == null)
                    name = "untitled";
            }
            else if (itsPatcher is FtsTemplateObject)
                name = "template " + itsPatcher.Description;
            else if (itsPatcher is FtsPatcherObject)
                name = "patcher " + itsPatcher.Description;
            else
                name = "template " + itsPatcher.Description;
            return name;
        }

        private ircam.jmax.toolkit.IEditorContainer iEditorContainer;
        public ircam.jmax.toolkit.IEditorContainer IEditorContainer { get { return iEditorContainer; } }
        public void Close(bool doCancel) { }
        public void Print() { }
        public void Save() { }
        public void SaveAs() { }

        public void UpdateTitle() { }
        public FtsPatcherObject PatcherBounds
        {
            set
            {
                //                int x;
                //                int y;
                //                int width;
                //                int height;
                //                
                //                x = value.WindowX;
                //                y = value.WindowY;
                //                width = ScaleTransform.Instance.scaleX(value.WindowWidth);
                //                height = ScaleTransform.Instance.scaleY(value.WindowHeight);
                //                
                //                if (width <= 0)
                //                    width = ScaleTransform.Instance.scaleX(480);
                //                
                //                if (height <= 0)
                //                    height = ScaleTransform.Instance.scaleY(500);
                //                
                //                Bounds = new System.Drawing.Rectangle(x, y, width + horizontalOffset(), height + verticalOffset());
            }

        }

        private void aboutMenuItem_Click(object sender, System.EventArgs e)
        {
            About();
        }

        private void contentsMenuItem_Click(object sender, System.EventArgs e)
        {
            Help.ShowHelp(this, helpfile);
        }

        private void InspectMenuItem_Click(object sender, System.EventArgs e)
        {
            ObjectInspector oi = new ObjectInspector();
            oi.ShowDialog(this);
            oi.Dispose();
        }

        private void newPatcherMenuItem_Click(object sender, System.EventArgs e)
        {
        }

        private void openMenuItem_Click(object sender, System.EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
            }
        }

        private void closeMenuItem_Click(object sender, System.EventArgs e)
        {
            this.Dispose();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            itsSketchPad.paintComponent(g);
        }

        private void LockMenuItem_Click(object sender, EventArgs e)
        {
            itsSketchPad.IsLocked = !itsSketchPad.IsLocked;
            LockMenuItem.Checked = itsSketchPad.IsLocked;
            Invalidate();
        }

        protected override void OnMouseDown(MouseEventArgs e)
        {
            Point mouse = new Point(e.X, e.Y);
            SensibilityArea area = null;
            area = itsSketchPad.Engine.displayList.GetObjectSensibilityAreaAt(e.X, e.Y);
            GraphicObject obj = (GraphicObject)area.Target;
            obj.gotSqueack(1, mouse, mouse);
        }
	}
}