//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax;
using ircam.jmax.fts;

namespace ircam.jmax.editors.patcher
{
    // Now cache on two index, name and size; all the fonts are created
    // and stored in this class
    // Not as fast as it can be ... for the moment, because make just a linear
    // search in the font table

    public class FontCache
    {
        internal static MaxVector fontTable = new MaxVector();
        internal static MaxVector fontMetricsTable = new MaxVector();


        private static int lookupFontIndex(string fontName, float fontSize, int fontStyle)
        {
            object[] objects = fontTable.ObjectArray;
            int osize = fontTable.Size;

            for (int i = 0; i < osize; i++)
            {
                System.Drawing.Font font = (System.Drawing.Font)objects[i];

                if ((fontSize == (int)font.Size) && (fontName.Equals(font.Name)) && (fontStyle == (int)font.Style))
                    return i;
            }

            return -1;
        }


        public static System.Drawing.Font lookupFont(string fontName, float fontSize, int fontStyle)
        {
            int idx;

            idx = lookupFontIndex(fontName, fontSize, fontStyle);

            if (idx < 0)
            {
                // Not found, make and store a new one

//UNDONE: If the given Font Name does not exist, a default Font instance is created.
                System.Drawing.Font font = new System.Drawing.Font(fontName, fontSize, (System.Drawing.FontStyle)fontStyle);

                fontTable.AddElement(font);
//UNDONE: Method 'java.awt.Toolkit.getFontMetrics' was not converted.
//UNDONE: Method 'java.awt.Toolkit.getDefaultToolkit' was not converted.
//              fontMetricsTable.addElement(Toolkit.getDefaultToolkit().getFontMetrics(font));

                return font;
            }
            else
                return (System.Drawing.Font)fontTable[idx];
        }


        public static System.Drawing.FontFamily lookupFontMetrics(string fontName, float fontSize, int fontStyle)
        {
            int idx;

            idx = lookupFontIndex(fontName, fontSize, fontStyle);

//          if (idx < 0)
//          {
//              // Not found, make and store a new one
//                
//UNDONE: If the given Font Name does not exist, a default Font instance is created.
//              System.Drawing.Font font = new System.Drawing.Font(fontName, fontSize, (System.Drawing.FontStyle) fontStyle);
//UNDONE: Method 'java.awt.Toolkit.getFontMetrics' was not converted. 
//UNDONE: Method 'java.awt.Toolkit.getDefaultToolkit' was not converted.
//              System.Drawing.Font fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
//              fontTable.addElement(font);
//              fontMetricsTable.addElement(fontMetrics);
//
//            return fontMetrics;
//          }
//          else
            return (System.Drawing.FontFamily)fontMetricsTable[idx];
        }
    }
}