//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;

using ircam.jmax;

namespace ircam.jmax.editors.patcher
{
    public class PatcherFontManager
    {
        private static PatcherFontManager fontManager = new PatcherFontManager();

        public PatcherFontManager()
        {
            initFontNameTable();
            initFontSizeTable();
        }

        public static PatcherFontManager Instance
        {
            get
            {
                return fontManager;
            }
        }

        internal void initFontNameTable()
        {
            for (int i = 0; i < maxFontNames.Length; i++)
                fontNames.Add(maxFontNames[i], defaultFontNames[i]);
        }

        internal void initFontSizeTable()
        {
            for (int i = 0; i < maxFontSizesNames.Length; i++)
                fontSizes.Add(maxFontSizesNames[i], defaultFontSizes[i]);
        }

        /****************************************************************************/
        /*                                                                          */
        /*           ACTIONS                                                        */
        /*                                                                          */
        /****************************************************************************/

        public string getFontName(string name)
        {
            return (string)(fontNames[name]);
        }

        public int getFontSize(string size)
        {
            return ((int)fontSizes[size]);
        }

        public bool isDefaultFontName(string name)
        {
            return fontNames.ContainsValue(name);
        }

        public string[] MaxFontSizes
        {
            get
            {
                return maxFontSizesNames;
            }
        }

        public string[] MaxFontNames
        {
            get
            {
                return maxFontNames;
            }
        }

        /***********************************************************************/
        /*   RUNTIME FONT RECOVERING                                           */
        /***********************************************************************/
        private string recoveringFont;
        private string[] toRecoverFonts = new string[] { };

        public string RecoveringFont
        {
            get
            {
                return recoveringFont;
            }
            set
            {
                recoveringFont = value;
            }
        }

        public string[] ToRecoverFonts
        {
            set
            {
                toRecoverFonts = value;
            }
        }

        public bool IsToRecoverFont(string font)
        {
            for (int i = 0; i < toRecoverFonts.Length; i++)
                if (font.Equals(toRecoverFonts[i]))
                    return true;
            return false;
        }
        /***********************************************************************/
        /***********************************************************************/

        private Hashtable fontNames = new Hashtable();
        private Hashtable fontSizes = new Hashtable();

        private string[] maxFontSizesNames = { "tiny", "small", "normal", "large", "larger", "huge" };
        private string[] maxFontNames = { "Variable Width Font", "Fixed Width Font" };
        private string[] defaultFontNames = { "Lucida Sans", "Lucida Bright" };
        private int[] defaultFontSizes = { 8, 10, 12, 14, 18, 24 };
    }
}