//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax.fts;
using ircam.fts.client;

namespace ircam.jmax.editors.patcher
{
    public class RuntimeError
    {
        private FtsGraphicObject obj;
        private string description;
        private int counter;

        public RuntimeError(FtsGraphicObject obj, string descr)
        {
            obj = obj;
            description = descr;
            counter = 0;
        }

        public FtsGraphicObject Object
        {
            get
            {
                return obj;
            }
        }

        public string Description
        {
            get
            {
                return description;
            }
        }

        public int Counter
        {
            get
            {
                return counter;
            }
            set
            {
                counter = value;
            }
        }

        public void IncrementCounter()
        {
            counter++;
        }

        public override bool Equals(object err)
        {
            return ((obj == ((RuntimeError)err).Object) && ((object)description == (object)((RuntimeError)err).Description));
        }

        public override int GetHashCode()
        {
            return obj.GetHashCode() ^ description.GetHashCode() ^ counter;
        }
    }
}