//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;
using System.Windows.Forms;

namespace ircam.jmax.editors.patcher
{
    public class Settings
    {
        private Color errorColor;
        private Color editBackgroundColor;
        private Color lockBackgroundColor;
        private Color uiColor;
        private Color objColor;
        private Color selectedColor;
        private Color textColor;
        private Color selectedTextColor;
        private Color consoleBackgroundColor;
        private Color consoleForegroundColor;

        private static readonly Settings singleInstance = new Settings();

        public Settings()
        {
//UNDONE: Method 'java.awt.Toolkit.getDefaultToolkit' was not converted.
//          Toolkit.getDefaultToolkit().sync();
            UIColor = Color.FromArgb(173, 224, 255);
            objColor = Color.FromArgb(153, 204, 204);
            editBackgroundColor = Color.FromArgb(230, 230, 230);
            lockBackgroundColor = Color.White;
            errorColor = Color.Red;
            selectedColor = Color.FromArgb(51, 153, 204);
            textColor = Color.Black;
            selectedTextColor = Color.Black;
            consoleBackgroundColor = Color.White;
            consoleForegroundColor = Color.Black;
        }

        public static Settings sharedInstance
        {
            get
            {
                return singleInstance;
            }
        }

        /* merry Xmas */
        public void setCoolColors()
        {
            editBackgroundColor = Color.Yellow;
            lockBackgroundColor = ControlPaint.Dark(Color.Blue);
            consoleBackgroundColor = ControlPaint.Dark(Color.Magenta);
            consoleForegroundColor = Color.White;
            objColor = Color.Pink;
            UIColor = Color.FromArgb(153, 204, 204);
            selectedColor = Color.Orange;
        }

        // ----------------------------------------
        // UIColor property
        // ----------------------------------------
        public Color UIColor
        {
            get
            {
                return uiColor;
            }
            set
            {
                this.uiColor = uiColor;
            }
        }

        // ----------------------------------------
        // ObjColor
        // ----------------------------------------
        public Color ObjColor
        {
            get
            {
                return objColor;
            }
            set
            {
                this.objColor = value;
            }
        }

        // ----------------------------------------
        // EditBackgroundColor
        // ----------------------------------------
        public Color EditBackgroundColor
        {

            get
            {
                return editBackgroundColor;
            }
            set
            {
                this.editBackgroundColor = value;
            }
        }

        // ----------------------------------------
        // LockBackgroundColor
        // ----------------------------------------
        public Color LockBackgroundColor
        {
            get
            {
                return lockBackgroundColor;
            }
            set
            {
                this.lockBackgroundColor = value;
            }
        }

        // ----------------------------------------
        // ErrorColor
        // ----------------------------------------
        public Color ErrorColor
        {
            get
            {
                return errorColor;
            }
            set
            {
                this.errorColor = value;
            }
        }

        // ----------------------------------------
        // SelectedColor
        // ----------------------------------------
        public Color SelectedColor
        {
            get
            {
                return selectedColor;
            }
            set
            {
                this.selectedColor = value;
            }
        }

        // ----------------------------------------
        // TextColor
        // ----------------------------------------
        public Color TextColor
        {
            get
            {
                return textColor;
            }
            set
            {
                this.textColor = value;
            }
        }

        // ----------------------------------------
        // SelectedTextColor
        // ----------------------------------------
        public Color SelectedTextColor
        {
            get
            {
                return selectedTextColor;
            }
            set
            {
                this.selectedTextColor = value;
            }
        }

        public Color ConsoleBackgroundColor
        {
            get
            {
                return consoleBackgroundColor;
            }
        }

        public Color ConsoleForegroundColor
        {
            get
            {
                return consoleForegroundColor;
            }
        }
    }
}