//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>The interaction handling drag-select; 
    /// started by a click on the background;
    /// Note that since the proper event sequence is guaranteed by the
    /// input system (i.e. Down [Drag]* Up), we don't need to keep track
    /// of the status here, so we have no real state-machine.
    /// </summary>

    internal class DragSelectInteraction : Interaction
    {
        internal Point dragStart = new Point();
        internal bool dragged = false;

        internal override void configureInputFilter(InteractionEngine filter)
        {
            // Note that following locations is false because
            // the first event is not handled by this filter,
            // but by the master interaction filter.

            filter.isFollowingMoves = true;
            filter.isAutoScrolling = true;
        }

        internal override void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            if (Squeack.isDown(squeack) && Squeack.onBackground(squeack))
            {
                dragged = false;
                dragStart = mouse;
                ErmesSelection.patcherSelection.redraw();
                ErmesSelection.patcherSelection.DeselectAll();
            }
            else if (Squeack.isDrag(squeack))
            {
                if (dragged)
                    editor.DisplayList.RedrawDragRectangle();

                editor.DisplayList.SetDragRectangle(dragStart.X, dragStart.Y, mouse.X - dragStart.X, mouse.Y - dragStart.Y);
                editor.DisplayList.DragRectangle();
                editor.DisplayList.SelectExactly(editor.DisplayList.GetDragRectangle());
                editor.DisplayList.RedrawDragRectangle();
                dragged = true;
            }
            else if (Squeack.isUp(squeack))
            {
                if (dragged)
                {
                    editor.DisplayList.NoDrag();
                    editor.DisplayList.RedrawDragRectangle();
                }
                editor.endInteraction();
            }
        }
    }
}