//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>A convenience abstract super class for all the interactions.
    /// Provide empty definition for all the lexical event methods,
    /// and a convenience variable to store the InteractionEngine.
    /// </summary>
    
    public abstract class Interaction
    {
        // This method configure the input filter
        // for this interaction; is called by the interaction engine.
        // by default, deinstall the move and the location handling
        
        internal virtual void configureInputFilter(InteractionEngine filter)
        {
        }
        
        // This method is also called by the interaction engine
        // to reset the state of the interaction; by default,
        // it do nothing
        
        internal virtual void reset()
        {
        }
        
        // Called for every squeack
        
        internal virtual void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, System.Drawing.Point mouse, System.Drawing.Point oldMouse)
        {
        }
        
        internal virtual Interaction delegateSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            return null;
        }
    }
}